/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.announcers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Article;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.sdk.git.JReleaserGpgSigner;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class ArticleAnnouncer
implements Announcer {
    private final JReleaserContext context;
    private Article article;

    ArticleAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "article";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getArticle().isEnabled();
    }

    public void announce() throws AnnounceException {
        this.article = this.context.getModel().getAnnounce().getArticle();
        Path prepareDirectory = this.context.getPrepareDirectory().resolve("article");
        this.prepareFiles(prepareDirectory);
        this.publishToRepository(prepareDirectory);
    }

    private void prepareFiles(Path prepareDirectory) throws AnnounceException {
        Path templateDirectory = this.context.getBasedir().resolve(this.article.getTemplateDirectory());
        try {
            FileUtils.deleteFiles((Path)prepareDirectory);
            Files.createDirectories(prepareDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_article_announcer", (Object[])new Object[]{this.context.relativizeToBasedir(templateDirectory)}), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"announcer.article.resolve.templates", (Object[])new Object[0]));
        Map props = this.context.props();
        props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
        this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
        props.putAll(this.article.getResolvedExtraProperties());
        try {
            for (Artifact file : this.article.getFiles()) {
                Path input = file.getResolvedPath(this.context, templateDirectory, true);
                Path output = file.getResolvedTransform(this.context, prepareDirectory);
                if (null == output) {
                    output = file.getResolvedPath(this.context, prepareDirectory, false);
                }
                BufferedReader reader = Files.newBufferedReader(input);
                this.context.getLogger().debug(RB.$((String)"announcer.article.eval.template", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(input)});
                String content = MustacheUtils.applyTemplate((Reader)reader, (Map)props);
                this.context.getLogger().debug(RB.$((String)"announcer.article.write.template", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(input)});
                this.writeFile(content, output);
            }
        }
        catch (JReleaserException e) {
            this.context.getLogger().warn(e.getMessage());
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_template_resolution", (Object[])new Object[]{this.context.relativizeToBasedir(templateDirectory)}), (Throwable)e);
        }
        catch (IOException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_template_resolution", (Object[])new Object[]{this.context.relativizeToBasedir(templateDirectory)}), (Throwable)e);
        }
    }

    private void publishToRepository(Path prepareDirectory) throws AnnounceException {
        this.context.getLogger().info(RB.$((String)"repository.setup", (Object[])new Object[0]), new Object[]{this.article.getRepository().getCanonicalRepoName()});
        if (this.context.isDryrun()) {
            return;
        }
        GitService gitService = this.context.getModel().getRelease().getGitService();
        try {
            this.context.getLogger().debug(RB.$((String)"repository.locate", (Object[])new Object[0]), new Object[]{this.article.getRepository().getCanonicalRepoName()});
            Repository repository = this.context.getReleaser().maybeCreateRepository(this.article.getRepository().getOwner(), this.article.getRepository().getResolvedName(), this.resolveGitToken(gitService));
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(this.resolveGitUsername(gitService), this.resolveGitToken(gitService));
            this.context.getLogger().debug(RB.$((String)"repository.clone", (Object[])new Object[0]), new Object[]{repository.getHttpUrl()});
            Path directory = Files.createTempDirectory("jreleaser-" + this.article.getRepository().getResolvedName(), new FileAttribute[0]);
            Git git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setBranch(this.article.getRepository().getBranch()).setDirectory(directory.toFile()).setURI(repository.getHttpUrl()).call();
            this.copyFiles(prepareDirectory, directory);
            git.add().addFilepattern(".").call();
            Map props = this.context.props();
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            this.context.getLogger().debug(RB.$((String)"repository.commit.setup", (Object[])new Object[0]));
            CommitCommand commitCommand = git.commit().setAll(true).setMessage(this.article.getRepository().getResolvedCommitMessage(props)).setAuthor(this.article.getCommitAuthor().getName(), this.article.getCommitAuthor().getEmail());
            commitCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            commitCommand = commitCommand.setSign(Boolean.valueOf(gitService.isSign())).setSigningKey("**********").setGpgSigner((GpgSigner)new JReleaserGpgSigner(this.context, gitService.isSign()));
            commitCommand.call();
            this.context.getLogger().info(RB.$((String)"repository.push", (Object[])new Object[0]), new Object[]{this.article.getRepository().getCanonicalRepoName()});
            this.context.getLogger().debug(RB.$((String)"repository.commit.push", (Object[])new Object[0]));
            ((PushCommand)git.push().setDryRun(false).setPushAll().setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
        }
        catch (Exception e) {
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_repository_update", (Object[])new Object[]{this.article.getRepository().getCanonicalRepoName()}), (Throwable)e);
        }
    }

    private void copyFiles(Path source, Path destination) throws IOException {
        this.context.getLogger().debug(RB.$((String)"repository.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(source)});
        if (!FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)source, (Path)destination)) {
            throw new IOException(RB.$((String)"ERROR_repository_copy_files", (Object[])new Object[]{this.context.relativizeToBasedir(source)}));
        }
    }

    private String resolveGitUsername(GitService gitService) {
        String username = this.article.getRepository().getResolvedUsername(gitService);
        return StringUtils.isNotBlank((String)username) ? username : gitService.getResolvedUsername();
    }

    private String resolveGitToken(GitService gitService) {
        String token = this.article.getRepository().getResolvedToken(gitService);
        return StringUtils.isNotBlank((String)token) ? token : gitService.getResolvedToken();
    }

    private void writeFile(String content, Path outputFile) throws AnnounceException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new AnnounceException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }
}

