/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Macports;
import org.jreleaser.model.Project;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class MacportsToolProcessor
extends AbstractRepositoryToolProcessor<Macports> {
    private static final String LINE_SEPARATOR = " \\\n                 ";

    public MacportsToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        String artifactFile;
        String distributionUrl;
        GitService gitService = this.context.getModel().getRelease().getGitService();
        props.put("macportsRepositoryRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Macports)this.tool).getRepository().getOwner(), ((Macports)this.tool).getRepository().getResolvedName()));
        props.put("macportsRepositoryRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Macports)this.tool).getRepository().getOwner(), ((Macports)this.tool).getRepository().getResolvedName()));
        List<String> longDescription = Arrays.asList(this.context.getModel().getProject().getLongDescription().split("\\n"));
        props.put("macportsPackageName", ((Macports)this.tool).getPackageName());
        props.put("macportsRevision", ((Macports)this.tool).getRevision());
        props.put("macportsCategories", String.join((CharSequence)" ", ((Macports)this.tool).getCategories()));
        props.put("macportsMaintainers", MustacheUtils.passThrough((String)String.join((CharSequence)LINE_SEPARATOR, ((Macports)this.tool).getResolvedMaintainers(this.context))));
        props.put("projectLongDescription", MustacheUtils.passThrough((String)String.join((CharSequence)LINE_SEPARATOR, longDescription)));
        if (distribution.getType() == Distribution.DistributionType.JAVA_BINARY) {
            props.put("macportsJavaVersion", this.resolveJavaVersion(distribution));
        }
        if ((distributionUrl = (String)props.get("distributionUrl")).endsWith(artifactFile = (String)props.get("distributionArtifactFile"))) {
            distributionUrl = distributionUrl.substring(0, distributionUrl.length() - artifactFile.length() - 1);
        }
        distributionUrl = distributionUrl.replace(this.context.getModel().getProject().getEffectiveVersion(), "${version}");
        props.put("macportsDistributionUrl", distributionUrl);
        String artifactFileName = (String)props.get("distributionArtifactFileName");
        String artifactName = (String)props.get("distributionArtifactName");
        String artifactVersion = (String)props.get("distributionArtifactVersion");
        props.put("macportsDistname", artifactFileName.replace(artifactName, "${name}").replace(artifactVersion, "${version}"));
    }

    private String resolveJavaVersion(Distribution distribution) {
        String version = distribution.getJava().getVersion();
        if ("8".equals(version)) {
            return "1.8+";
        }
        try {
            Integer.parseInt(version);
            return version + "+";
        }
        catch (NumberFormatException numberFormatException) {
            return version;
        }
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        Path outputFile = "Portfile".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("ports").resolve((String)((Macports)this.tool).getCategories().get(0)).resolve(((Macports)this.tool).getPackageName()).resolve(fileName) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected boolean isSkipped(Artifact artifact) {
        return StringUtils.isTrue(artifact.getExtraProperties().get("skipMacports"));
    }
}

