/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.assembler.spi.AssemblerProcessor;
import org.jreleaser.model.assembler.spi.AssemblerProcessorFactory;

public class AssemblerProcessors {
    public static <A extends Assembler> AssemblerProcessor<A> findProcessor(JReleaserContext context, A assembler) {
        Map<String, AssemblerProcessor> processors = StreamSupport.stream(ServiceLoader.load(AssemblerProcessorFactory.class, AssemblerProcessors.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(AssemblerProcessorFactory::getName, factory -> factory.getAssemblerProcessor(context)));
        if (processors.containsKey(assembler.getType())) {
            AssemblerProcessor assemblerProcessor = processors.get(assembler.getType());
            assemblerProcessor.setAssembler(assembler);
            return assemblerProcessor;
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_assembler", (Object[])new Object[]{assembler.getType()}));
    }
}

