/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.distribution;

import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.distribution.DistributionProcessor;
import org.jreleaser.engine.distribution.ToolProcessingFunction;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.tool.spi.ToolProcessingException;

public class Distributions {
    public static void process(JReleaserContext context, String action, ToolProcessingFunction function) {
        List activeDistributions = context.getModel().getActiveDistributions();
        if (activeDistributions.isEmpty()) {
            context.getLogger().debug(RB.$((String)"distributions.not.enabled", (Object[])new Object[0]), new Object[]{action.toLowerCase()});
            return;
        }
        if (context.hasDistributionName()) {
            Distribution distribution = context.getModel().findDistribution(context.getDistributionName());
            if (null == distribution) {
                context.getLogger().error(RB.$((String)"distributions.no.match", (Object[])new Object[0]), new Object[]{context.getDistributionName()});
                return;
            }
            if (context.hasToolName()) {
                Distributions.processDistribution(context, action, distribution, context.getToolName(), function);
            } else {
                Distributions.processDistribution(context, action, distribution, function);
            }
            return;
        }
        if (context.hasToolName()) {
            context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action});
            for (Distribution distribution : activeDistributions) {
                Distributions.processDistribution(context, action, distribution, context.getToolName(), function);
            }
            return;
        }
        context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action});
        for (Distribution distribution : activeDistributions) {
            Distributions.processDistribution(context, action, distribution, function);
        }
    }

    private static void processDistribution(JReleaserContext context, String action, Distribution distribution, ToolProcessingFunction function) {
        context.getLogger().increaseIndent();
        context.getLogger().info(RB.$((String)"distributions.apply.action.to", (Object[])new Object[0]), new Object[]{action, distribution.getName()});
        for (String toolName : Distribution.supportedTools()) {
            Distributions.processTool(context, distribution, toolName, function);
        }
        context.getLogger().decreaseIndent();
    }

    private static void processDistribution(JReleaserContext context, String action, Distribution distribution, String toolName, ToolProcessingFunction function) {
        context.getLogger().increaseIndent();
        context.getLogger().info(RB.$((String)"distributions.apply.action.to", (Object[])new Object[0]), new Object[]{action, distribution.getName()});
        Distributions.processTool(context, distribution, toolName, function);
        context.getLogger().decreaseIndent();
    }

    private static void processTool(JReleaserContext context, Distribution distribution, String toolName, ToolProcessingFunction function) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix(toolName);
        try {
            DistributionProcessor processor = Distributions.createDistributionProcessor(context, distribution, toolName);
            function.consume(processor);
        }
        catch (ToolProcessingException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        context.getLogger().restorePrefix();
        context.getLogger().decreaseIndent();
    }

    private static DistributionProcessor createDistributionProcessor(JReleaserContext context, Distribution distribution, String toolName) {
        return DistributionProcessor.builder().context(context).distributionName(distribution.getName()).toolName(toolName).build();
    }
}

