/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Constant;

public class LintStreamReader
extends StreamReader {
    private String name = "'reader'";
    private int dataLength = 0;
    private int pointer = 0;
    private int index = 0;
    private int line = 0;
    private int column = 0;
    private int[] buffer;

    public LintStreamReader(String stream) {
        this(new StringReader(stream));
        this.name = "'string'";
    }

    public LintStreamReader(Reader reader) {
        super(reader);
        try {
            this.buffer = this.read(reader);
        }
        catch (IOException e) {
            this.buffer = new int[0];
            throw new IllegalArgumentException("cannot read data from reader", e);
        }
    }

    public Mark getMark() {
        return new Mark(this.name, this.index, this.line, this.column, this.buffer, this.pointer);
    }

    public void forward(int length) {
        for (int i = 0; i < length && this.hasEnoughData(); ++i) {
            int c = this.buffer[this.pointer++];
            ++this.index;
            if (Constant.LINEBR.has(c) || c == 13 && this.hasEnoughData() && this.buffer[this.pointer] != 10) {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (c == 65279) continue;
            ++this.column;
        }
    }

    public int peek() {
        return this.hasEnoughData() ? this.buffer[this.pointer] : 0;
    }

    public int peek(int index) {
        return this.hasEnoughData(index) ? this.buffer[this.pointer + index] : 0;
    }

    public String prefix(int length) {
        if (length == 0) {
            return "";
        }
        if (this.hasEnoughData(length)) {
            return new String(this.buffer, this.pointer, length);
        }
        return new String(this.buffer, this.pointer, Math.min(length, this.dataLength - this.pointer));
    }

    public String prefixForward(int length) {
        String prefix = this.prefix(length);
        this.pointer += length;
        this.index += length;
        this.column += length;
        return prefix;
    }

    private boolean hasEnoughData() {
        return this.hasEnoughData(0);
    }

    private boolean hasEnoughData(int size) {
        return this.pointer + size < this.buffer.length;
    }

    private int[] read(Reader reader) throws IOException {
        int c;
        ArrayList<Character> data = new ArrayList<Character>();
        while ((c = reader.read()) >= 0) {
            data.add(Character.valueOf((char)c));
        }
        this.dataLength = data.size();
        char[] b = new char[this.dataLength];
        for (int i = 0; i < this.dataLength; ++i) {
            b[i] = ((Character)data.get(i)).charValue();
        }
        return LintStreamReader.toCodePoints(b);
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    private static int[] toCodePoints(char[] str) {
        int[] codePoints = new int[Character.codePointCount(str, 0, str.length)];
        int i = 0;
        int c = 0;
        while (i < str.length) {
            int cp;
            codePoints[c] = cp = Character.codePointAt(str, i);
            i += Character.charCount(cp);
            ++c;
        }
        return codePoints;
    }
}

