/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.model.Active;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.GenericGit;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Project;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.ResourceUtils;
import org.jreleaser.util.StringUtils;

public abstract class GitServiceValidator
extends Validator {
    private static final String DEFAULT_CHANGELOG_TPL = "src/jreleaser/templates/changelog.tpl";

    public static void validateGitService(JReleaserContext context, JReleaserContext.Mode mode, GitService service, Errors errors) {
        JReleaserModel model = context.getModel();
        Project project = model.getProject();
        if (!service.isEnabledSet()) {
            service.setEnabled(true);
        }
        if (StringUtils.isBlank((String)service.getOwner()) && !(service instanceof GenericGit)) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{service.getServiceName() + ".owner"}));
        }
        if (StringUtils.isBlank((String)service.getName())) {
            service.setName(project.getName());
        }
        service.setUsername(GitServiceValidator.checkProperty(context, service.getServiceName().toUpperCase() + "_USERNAME", service.getServiceName() + ".username", service.getUsername(), service.getOwner()));
        service.setToken(GitServiceValidator.checkProperty(context, service.getServiceName().toUpperCase() + "_TOKEN", service.getServiceName() + ".token", service.getToken(), errors));
        service.setTagName(GitServiceValidator.checkProperty(context, "TAG_NAME", service.getServiceName() + ".tagName", service.getTagName(), "v{{projectVersion}}"));
        if (service.isReleaseSupported()) {
            service.setReleaseName(GitServiceValidator.checkProperty(context, "RELEASE_NAME", service.getServiceName() + ".releaseName", service.getReleaseName(), "Release {{tagName}}"));
        }
        service.setBranch(GitServiceValidator.checkProperty(context, "BRANCH", service.getServiceName() + ".branch", service.getBranch(), "main"));
        if (!service.isOverwriteSet()) {
            service.setOverwrite(GitServiceValidator.checkProperty(context, "OVERWRITE", service.getServiceName() + ".overwrite", null, false));
        }
        if (service.isReleaseSupported()) {
            if (!service.isUpdateSet()) {
                service.setUpdate(GitServiceValidator.checkProperty(context, "UPDATE", service.getServiceName() + ".update", null, false));
            }
            if (service.isUpdate() && service.getUpdateSections().isEmpty()) {
                service.getUpdateSections().add(UpdateSection.ASSETS);
            }
        }
        if (!service.isSkipTagSet()) {
            service.setSkipTag(GitServiceValidator.checkProperty(context, "SKIP_TAG", service.getServiceName() + ".skipTag", null, false));
        }
        if (!service.isSkipReleaseSet()) {
            service.setSkipRelease(GitServiceValidator.checkProperty(context, "SKIP_RELEASE", service.getServiceName() + ".skipRelease", null, false));
        }
        if (StringUtils.isBlank((String)service.getTagName())) {
            service.setTagName("v" + project.getVersion());
        }
        if (service.isReleaseSupported() && StringUtils.isBlank((String)service.getReleaseName())) {
            service.setReleaseName("Release {{ tagName }}");
        }
        if (!service.getChangelog().isEnabledSet()) {
            service.getChangelog().setEnabled(true);
        }
        if (StringUtils.isBlank((String)service.getCommitAuthor().getName())) {
            service.getCommitAuthor().setName("jreleaserbot");
        }
        if (StringUtils.isBlank((String)service.getCommitAuthor().getEmail())) {
            service.getCommitAuthor().setEmail("jreleaser@kordamp.org");
        }
        GitServiceValidator.validateTimeout(service);
        if (service.isReleaseSupported()) {
            service.getMilestone().setName(GitServiceValidator.checkProperty(context, "MILESTONE_NAME", service.getServiceName() + ".milestone.name", service.getMilestone().getName(), "{{tagName}}"));
        }
        service.getResolvedTagName(context.getModel());
        if (service.isReleaseSupported()) {
            service.getResolvedReleaseName(context.getModel());
            service.getMilestone().getResolvedName(service.props(context.getModel()));
        }
        if (project.isSnapshot()) {
            service.getChangelog().setEnabled(true);
            service.getChangelog().setExternal(null);
            service.getChangelog().setSort(Changelog.Sort.DESC);
            if (service.isReleaseSupported()) {
                service.setOverwrite(true);
            }
        }
        if (mode != JReleaserContext.Mode.ASSEMBLE) {
            if (service.isSign() && !model.getSigning().isEnabled()) {
                if (context.isDryrun()) {
                    service.setSign(false);
                } else {
                    errors.configuration(RB.$((String)"validation_git_signing", (Object[])new Object[]{service.getServiceName()}));
                }
            }
            GitServiceValidator.validateChangelog(context, service, errors);
        }
    }

    private static void validateChangelog(JReleaserContext context, GitService service, Errors errors) {
        int i;
        Changelog changelog = service.getChangelog();
        if (StringUtils.isNotBlank((String)changelog.getExternal())) {
            changelog.setFormatted(Active.NEVER);
        }
        if (!changelog.resolveFormatted(context.getModel().getProject())) {
            return;
        }
        if (StringUtils.isBlank((String)changelog.getFormat())) {
            changelog.setFormat("- {{commitShortHash}} {{commitTitle}} ({{commitAuthor}})");
        }
        if (StringUtils.isBlank((String)changelog.getContent()) && StringUtils.isBlank((String)changelog.getContentTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_CHANGELOG_TPL), new LinkOption[0])) {
                changelog.setContentTemplate(DEFAULT_CHANGELOG_TPL);
            } else {
                changelog.setContent(System.lineSeparator() + "## Changelog" + System.lineSeparator() + System.lineSeparator() + "{{changelogChanges}}" + System.lineSeparator() + "    {{changelogContributors}}");
            }
        }
        if (StringUtils.isNotBlank((String)changelog.getContentTemplate()) && !Files.exists(context.getBasedir().resolve(changelog.getContentTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"changelog.contentTemplate", changelog.getContentTemplate()}));
        }
        if (StringUtils.isNotBlank((String)changelog.getPreset())) {
            GitServiceValidator.loadPreset(context, changelog, errors);
        }
        if (changelog.getCategories().isEmpty()) {
            changelog.getCategories().add(Changelog.Category.of(RB.$((String)"default_category_feature", (Object[])new Object[0]), "", "feature", "enhancement"));
            changelog.getCategories().add(Changelog.Category.of(RB.$((String)"default_category_bug_fix", (Object[])new Object[0]), "", "bug", "fix"));
        } else {
            i = 0;
            for (Changelog.Category category : changelog.getCategories()) {
                if (StringUtils.isBlank((String)category.getTitle())) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.categories[" + i + "].title"}));
                }
                if (category.getLabels().isEmpty()) {
                    errors.configuration(RB.$((String)"validation_ares_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.categories[" + i + "].labels"}));
                }
                ++i;
            }
            Map<String, List<Changelog.Category>> byTitle = changelog.getCategories().stream().collect(Collectors.groupingBy(Changelog.Category::getTitle));
            byTitle.forEach((title, categories) -> {
                if (categories.size() > 1) {
                    errors.configuration(RB.$((String)"validation_changelog_multiple_categories", (Object[])new Object[]{service.getServiceName(), title}));
                }
            });
        }
        if (!changelog.getLabelers().isEmpty()) {
            i = 0;
            for (Changelog.Labeler labeler : changelog.getLabelers()) {
                if (StringUtils.isBlank((String)labeler.getLabel())) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.labelers[" + i + "].label"}));
                }
                if (StringUtils.isBlank((String)labeler.getTitle()) && StringUtils.isBlank((String)labeler.getBody())) {
                    errors.configuration(RB.$((String)"validation_git_required", (Object[])new Object[]{service.getServiceName() + ".changelog.labelers[" + i + "] title", "body"}));
                }
                ++i;
            }
        }
        if (!changelog.getReplacers().isEmpty()) {
            i = 0;
            for (Changelog.Replacer replacer : changelog.getReplacers()) {
                if (StringUtils.isBlank((String)replacer.getSearch())) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.replacers[" + i + "].search"}));
                }
                if (null == replacer.getReplace()) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{service.getServiceName() + ".changelog.replacers[" + i + "].replace"}));
                }
                ++i;
            }
        }
        if (!changelog.getContributors().isEnabledSet()) {
            changelog.getContributors().setEnabled(true);
        }
    }

    private static void loadPreset(JReleaserContext context, Changelog changelog, Errors errors) {
        URL location = ResourceUtils.resolveLocation(Changelog.class);
        if (null == location) {
            context.getLogger().warn(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
            return;
        }
        try {
            if ("file".equals(location.getProtocol())) {
                String preset = changelog.getPreset().toLowerCase().trim();
                String presetFileName = "META-INF/jreleaser/changelog/preset-" + preset + ".yml";
                boolean found = false;
                JarFile jarFile = new JarFile(new File(location.toURI()));
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (entry.isDirectory() || !entry.getName().equals(presetFileName)) continue;
                    Changelog loaded = JReleaserConfigLoader.load(Changelog.class, presetFileName, jarFile.getInputStream(entry));
                    LinkedHashSet<Changelog.Labeler> labelersCopy = new LinkedHashSet<Changelog.Labeler>(changelog.getLabelers());
                    labelersCopy.addAll(loaded.getLabelers());
                    changelog.setLabelers(labelersCopy);
                    ArrayList<Changelog.Replacer> replacersCopy = new ArrayList<Changelog.Replacer>(changelog.getReplacers());
                    replacersCopy.addAll(loaded.getReplacers());
                    changelog.setReplacers(replacersCopy);
                    Map<String, List<Changelog.Category>> categoriesByTitle = changelog.getCategories().stream().collect(Collectors.groupingBy(Changelog.Category::getTitle));
                    Map<String, List<Changelog.Category>> loadedCategoriesByTitle = loaded.getCategories().stream().collect(Collectors.groupingBy(Changelog.Category::getTitle));
                    categoriesByTitle.forEach((categoryTitle, categories) -> {
                        if (loadedCategoriesByTitle.containsKey(categoryTitle)) {
                            Changelog.Category loadedCategory = (Changelog.Category)((List)loadedCategoriesByTitle.remove(categoryTitle)).get(0);
                            ((Changelog.Category)categories.get(0)).addLabels(loadedCategory.getLabels());
                        }
                    });
                    loaded.getCategories().forEach(category -> {
                        if (loadedCategoriesByTitle.containsKey(category.getTitle())) {
                            changelog.getCategories().add((Changelog.Category)category);
                        }
                    });
                    changelog.getHide().addCategories(loaded.getHide().getCategories());
                    changelog.getHide().addContributors(loaded.getHide().getContributors());
                    found = true;
                    break;
                }
                if (!found) {
                    context.getLogger().warn(RB.$((String)"changelog.preset.not.found", (Object[])new Object[0]), new Object[]{preset});
                }
            } else {
                context.getLogger().warn(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
            }
        }
        catch (IOException | URISyntaxException e) {
            context.getLogger().warn(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
        }
    }
}

