/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Set;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Scoop;
import org.jreleaser.model.ScoopBucket;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ScoopValidator
extends Validator {
    public static void validateScoop(JReleaserContext context, Distribution distribution, Scoop tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Scoop parentTool = model.getPackagers().getScoop();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.scoop", new Object[]{distribution.getName()});
        ScoopValidator.validateCommitAuthor(tool, parentTool);
        ScoopBucket bucket = tool.getBucket();
        bucket.resolveEnabled(model.getProject());
        ScoopValidator.validateTap(context, distribution, bucket, parentTool.getBucket(), "scoop.bucket");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        ScoopValidator.validateContinueOnError(tool, parentTool);
        if (StringUtils.isBlank((String)tool.getCheckverUrl())) {
            tool.setCheckverUrl(parentTool.getCheckverUrl());
            if (StringUtils.isBlank((String)tool.getCheckverUrl())) {
                tool.setCheckverUrl(service.getLatestReleaseUrl());
            }
        }
        if (StringUtils.isBlank((String)tool.getAutoupdateUrl())) {
            tool.setAutoupdateUrl(parentTool.getAutoupdateUrl());
            if (StringUtils.isBlank((String)tool.getAutoupdateUrl())) {
                tool.setAutoupdateUrl(service.getDownloadUrl());
            }
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
        Set<String> fileExtensions = tool.getSupportedExtensions();
        distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).filter(artifact -> tool.supportsPlatform(artifact.getPlatform())).forEach(artifact -> artifact.getExtraProperties().put("individualChecksum", true));
    }
}

