/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class NativeImageValidator
extends Validator {
    public static void validateNativeImage(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("nativeImage");
        Map<String, NativeImage> nativeImage = context.getModel().getAssemble().getNativeImage();
        for (Map.Entry<String, NativeImage> e : nativeImage.entrySet()) {
            e.getValue().setName(e.getKey());
            NativeImageValidator.validateNativeImage(context, mode, e.getValue(), errors);
        }
    }

    private static void validateNativeImage(JReleaserContext context, JReleaserContext.Mode mode, NativeImage nativeImage, Errors errors) {
        context.getLogger().debug("nativeImage.{}", new Object[]{nativeImage.getName()});
        if (!nativeImage.isActiveSet()) {
            nativeImage.setActive(Active.NEVER);
        }
        if (!nativeImage.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (StringUtils.isBlank((String)nativeImage.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"nativeImage.name"}));
            return;
        }
        if (StringUtils.isBlank((String)nativeImage.getExecutable())) {
            nativeImage.setExecutable(nativeImage.getName());
        }
        if (StringUtils.isBlank((String)nativeImage.getImageName())) {
            nativeImage.setImageName(nativeImage.getExecutable() + "-" + context.getModel().getProject().getResolvedVersion());
        }
        if (StringUtils.isBlank((String)nativeImage.getGraal().getPath())) {
            nativeImage.getGraal().setPath(System.getProperty("java.home"));
        }
        if (StringUtils.isBlank((String)nativeImage.getGraal().getPlatform())) {
            nativeImage.getGraal().setPlatform(PlatformUtils.getCurrentFull());
        }
        if (null == nativeImage.getMainJar()) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".mainJar"}));
            return;
        }
        if (StringUtils.isBlank((String)nativeImage.getMainJar().getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".mainJar.path"}));
        }
        NativeImageValidator.validateGlobs(context, nativeImage.getJars(), "nativeImage." + nativeImage.getName() + ".jars", errors);
        if (mode == JReleaserContext.Mode.ASSEMBLE) {
            TemplateValidator.validateTemplate(context, nativeImage, errors);
        }
        if (!nativeImage.getFileSets().isEmpty()) {
            int i = 0;
            for (FileSet fileSet : nativeImage.getFileSets()) {
                NativeImageValidator.validateFileSet(context, mode, nativeImage, fileSet, i++, errors);
            }
        }
    }
}

