/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.templates;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public final class TemplateUtils {
    private static final Properties TEMPLATES_INVENTORY = new Properties();
    private static final String BASE_TEMPLATE_PREFIX = "META-INF/jreleaser/templates/";

    private TemplateUtils() {
    }

    public static String trimTplExtension(String str) {
        if (str.endsWith(".tpl")) {
            return str.substring(0, str.length() - 4);
        }
        return str;
    }

    public static Map<String, Reader> resolveAndMergeTemplates(JReleaserLogger logger, String distributionType, String toolName, boolean snapshot, Path templateDirectory) {
        Map<String, Reader> templates = TemplateUtils.resolveTemplates(logger, distributionType, toolName, snapshot);
        if (null != templateDirectory && templateDirectory.toFile().exists()) {
            templates.putAll(TemplateUtils.resolveTemplates(distributionType, toolName, snapshot, templateDirectory));
        }
        return templates;
    }

    public static Map<String, Reader> resolveTemplates(String distributionType, String toolName, boolean snapshot, Path templateDirectory) {
        final LinkedHashMap<String, Reader> templates = new LinkedHashMap<String, Reader>();
        Path snapshotTemplateDirectory = templateDirectory.resolveSibling(templateDirectory.getFileName() + "-snapshot");
        Path directory = templateDirectory;
        if (snapshot && snapshotTemplateDirectory.toFile().exists()) {
            directory = snapshotTemplateDirectory;
        }
        final Path actualTemplateDirectory = directory;
        try {
            Files.walkFileTree(actualTemplateDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    templates.put(actualTemplateDirectory.relativize(file).toString(), Files.newBufferedReader(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            String distributionTypeName = distributionType.toLowerCase().replace('_', '-');
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_distribution", (Object[])new Object[]{distributionTypeName, toolName, actualTemplateDirectory.toAbsolutePath()}));
        }
        return templates;
    }

    public static Map<String, Reader> resolveTemplates(final Path templateDirectory) {
        final LinkedHashMap<String, Reader> templates = new LinkedHashMap<String, Reader>();
        try {
            Files.walkFileTree(templateDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    templates.put(templateDirectory.relativize(file).toString(), Files.newBufferedReader(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_from", (Object[])new Object[]{templateDirectory.toAbsolutePath()}));
        }
        return templates;
    }

    public static Map<String, Reader> resolveTemplates(JReleaserLogger logger, String distributionType, String toolName, boolean snapshot) {
        String distributionTypeName = distributionType.toLowerCase().replace('_', '-');
        LinkedHashMap<String, Reader> templates = new LinkedHashMap<String, Reader>();
        logger.debug(RB.$((String)"templates.templates.resolve.classpath", (Object[])new Object[0]));
        String templatePrefix = distributionTypeName + "." + toolName.toLowerCase() + (snapshot ? "-snapshot" : "");
        logger.debug(RB.$((String)"templates.template.resolve.classpath", (Object[])new Object[]{templatePrefix}));
        String values = TEMPLATES_INVENTORY.getProperty(templatePrefix);
        if (StringUtils.isBlank((String)values) && snapshot) {
            templatePrefix = distributionTypeName + "." + toolName.toLowerCase();
            logger.debug(RB.$((String)"templates.template.resolve.classpath", (Object[])new Object[]{templatePrefix}));
            values = TEMPLATES_INVENTORY.getProperty(templatePrefix);
        }
        if (StringUtils.isNotBlank((String)values)) {
            for (String k : values.split(",")) {
                templates.put(k, TemplateUtils.resolveTemplate(logger, distributionTypeName + "/" + toolName.toLowerCase() + "/" + k));
            }
        }
        return templates;
    }

    public static Reader resolveTemplate(JReleaserLogger logger, String templateKey) {
        logger.debug(RB.$((String)"templates.template.resolve.classpath", (Object[])new Object[0]), new Object[]{templateKey});
        try {
            InputStream inputStream = TemplateUtils.class.getClassLoader().getResourceAsStream(BASE_TEMPLATE_PREFIX + templateKey);
            if (null == inputStream) {
                throw new JReleaserException(RB.$((String)"ERROR_template_not_found", (Object[])new Object[]{BASE_TEMPLATE_PREFIX + templateKey}));
            }
            return new InputStreamReader(inputStream);
        }
        catch (Exception e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_template_for", (Object[])new Object[]{templateKey, "classpath"}));
        }
    }

    static {
        try {
            TEMPLATES_INVENTORY.load(TemplateUtils.class.getResourceAsStream("/META-INF/jreleaser/templates.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

