/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Collections;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Macports;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MacportsValidator
extends Validator {
    public static void validateMacports(JReleaserContext context, Distribution distribution, Macports packager, Errors errors) {
        JReleaserModel model = context.getModel();
        Macports parentPackager = model.getPackagers().getMacports();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            packager.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            packager.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.macports", new Object[]{distribution.getName()});
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".macports"}));
            packager.disable();
            return;
        }
        context.getModel().getChecksum().getAlgorithms().add(Algorithm.RMD160);
        if (null == packager.getRevision()) {
            packager.setRevision(parentPackager.getRevision());
        }
        if (null == packager.getRevision()) {
            packager.setRevision(0);
        }
        if (packager.getMaintainers().isEmpty()) {
            packager.setMaintainers(parentPackager.getMaintainers());
        }
        if (packager.getCategories().isEmpty()) {
            packager.setCategories(parentPackager.getCategories());
        }
        if (packager.getCategories().isEmpty()) {
            packager.setCategories(Collections.singletonList("devel"));
        }
        if (distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE) {
            if (!packager.getExtraProperties().containsKey("appName") && parentPackager.getExtraProperties().containsKey("appName")) {
                packager.getExtraProperties().put("appName", parentPackager.getExtraProperties().get("appName"));
            }
            if (!packager.getExtraProperties().containsKey("appName")) {
                packager.getExtraProperties().put("appName", distribution.getName() + ".app");
            }
        }
        MacportsValidator.validateCommitAuthor(packager, parentPackager);
        Macports.MacportsRepository repository = packager.getRepository();
        repository.resolveEnabled(model.getProject());
        MacportsValidator.validateTap(context, distribution, repository, parentPackager.getRepository(), "macports.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        MacportsValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }
}

