/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.Platform;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class NativeImageValidator
extends Validator {
    public static void validateNativeImage(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("nativeImage");
        Map<String, NativeImage> nativeImage = context.getModel().getAssemble().getNativeImage();
        for (Map.Entry<String, NativeImage> e : nativeImage.entrySet()) {
            e.getValue().setName(e.getKey());
            NativeImageValidator.validateNativeImage(context, mode, e.getValue(), errors);
        }
    }

    private static void validateNativeImage(JReleaserContext context, JReleaserContext.Mode mode, NativeImage nativeImage, Errors errors) {
        NativeImage.Upx upx;
        context.getLogger().debug("nativeImage.{}", new Object[]{nativeImage.getName()});
        if (!nativeImage.isActiveSet()) {
            nativeImage.setActive(Active.NEVER);
        }
        if (!nativeImage.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (StringUtils.isBlank((String)nativeImage.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"nativeImage.name"}));
            return;
        }
        if (null == nativeImage.getMainJar()) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".mainJar"}));
            return;
        }
        Platform platform = nativeImage.getPlatform().merge(context.getModel().getPlatform());
        nativeImage.setPlatform(platform);
        if (StringUtils.isBlank((String)nativeImage.getExecutable())) {
            nativeImage.setExecutable(nativeImage.getName());
        }
        if (StringUtils.isBlank((String)nativeImage.getImageName())) {
            nativeImage.setImageName(nativeImage.getExecutable() + "-" + context.getModel().getProject().getResolvedVersion());
        }
        int i = 0;
        for (Artifact graalJdk : nativeImage.getGraalJdks()) {
            NativeImageValidator.validateJdk(context, mode, nativeImage, graalJdk, i++, errors);
        }
        Map<String, List<Artifact>> byPlatform = nativeImage.getGraalJdks().stream().collect(Collectors.groupingBy(jdk -> StringUtils.isBlank((String)jdk.getPlatform()) ? "<nil>" : jdk.getPlatform()));
        if (byPlatform.containsKey("<nil>")) {
            errors.configuration(RB.$((String)"validation_nativeimage_jdk_platform", (Object[])new Object[]{nativeImage.getName()}));
        }
        byPlatform.forEach((p, jdks) -> {
            if (jdks.size() > 1) {
                errors.configuration(RB.$((String)"validation_nativeimage_jdk_multiple_platforms", (Object[])new Object[]{nativeImage.getName(), p}));
            }
        });
        if (StringUtils.isBlank((String)nativeImage.getGraal().getPath())) {
            String currentPlatform = PlatformUtils.getCurrentFull();
            String javaHome = System.getProperty("java.home");
            if (nativeImage.getGraalJdks().isEmpty()) {
                if (StringUtils.isBlank((String)javaHome)) {
                    errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                    return;
                }
                nativeImage.getGraal().setPath(javaHome);
                nativeImage.getGraal().setPlatform(currentPlatform);
            } else {
                Optional<Artifact> jdk2 = nativeImage.getGraalJdks().stream().filter(j -> PlatformUtils.isCompatible((String)currentPlatform, (String)j.getPlatform())).findFirst();
                if (jdk2.isPresent()) {
                    nativeImage.setGraal(jdk2.get());
                } else {
                    if (StringUtils.isBlank((String)javaHome)) {
                        errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                        return;
                    }
                    nativeImage.getGraal().setPath(javaHome);
                    nativeImage.getGraal().setPlatform(currentPlatform);
                }
            }
        }
        if (StringUtils.isBlank((String)nativeImage.getMainJar().getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".mainJar.path"}));
        }
        if (null == nativeImage.getArchiveFormat()) {
            nativeImage.setArchiveFormat(Archive.Format.ZIP);
        }
        NativeImageValidator.validateGlobs(context, nativeImage.getJars(), "nativeImage." + nativeImage.getName() + ".jars", errors);
        if (mode == JReleaserContext.Mode.ASSEMBLE) {
            TemplateValidator.validateTemplate(context, nativeImage, errors);
        }
        if (!nativeImage.getFileSets().isEmpty()) {
            i = 0;
            for (FileSet fileSet : nativeImage.getFileSets()) {
                NativeImageValidator.validateFileSet(context, mode, nativeImage, fileSet, i++, errors);
            }
        }
        if (!(upx = nativeImage.getUpx()).isActiveSet()) {
            upx.setActive(Active.NEVER);
        }
        if (!upx.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (StringUtils.isBlank((String)upx.getVersion())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".upx.version"}));
        }
    }

    private static void validateJdk(JReleaserContext context, JReleaserContext.Mode mode, NativeImage nativeImage, Artifact jdk, int index, Errors errors) {
        if (mode == JReleaserContext.Mode.FULL) {
            return;
        }
        if (null == jdk) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".graalJdk[" + index + "]"}));
            return;
        }
        if (StringUtils.isBlank((String)jdk.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"nativeImage." + nativeImage.getName() + ".graalJdk[" + index + "].path"}));
        }
        if (StringUtils.isNotBlank((String)jdk.getPlatform()) && !PlatformUtils.isSupported((String)jdk.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_nativeimage_platform", (Object[])new Object[]{nativeImage.getName(), index, jdk.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }
}

