/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.engine.context.ModelAutoConfigurer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="release")
public class Release
extends AbstractPlatformAwareModelCommand {
    @CommandLine.Option(names={"--dry-run"})
    boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected JReleaserContext createContext() {
        JReleaserContext context = super.createContext();
        if (null != this.composite) {
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
        }
        return context;
    }

    @Override
    protected void execute() {
        if (this.composite == null || !this.composite.autoConfig()) {
            super.execute();
            return;
        }
        this.basedir();
        this.initLogger();
        JReleaserContext context = ModelAutoConfigurer.builder().logger(this.logger).basedir(this.actualBasedir).outputDirectory(this.getOutputDirectory()).dryrun(this.dryrun()).gitRootSearch(this.gitRootSearch).projectName(this.composite.autoConfig.projectName).projectVersion(this.composite.autoConfig.projectVersion).projectVersionPattern(this.composite.autoConfig.projectVersionPattern).projectSnapshotPattern(this.composite.autoConfig.projectSnapshotPattern).projectSnapshotLabel(this.composite.autoConfig.projectSnapshotLabel).projectSnapshotFullChangelog(this.composite.autoConfig.projectSnapshotFullChangelog).tagName(this.composite.autoConfig.tagName).previousTagName(this.composite.autoConfig.previousTagName).releaseName(this.composite.autoConfig.releaseName).milestoneName(this.composite.autoConfig.milestoneName).branch(this.composite.autoConfig.branch).prerelease(this.composite.autoConfig.prerelease).prereleasePattern(this.composite.autoConfig.prereleasePattern).draft(this.composite.autoConfig.draft).overwrite(this.composite.autoConfig.overwrite).update(this.composite.autoConfig.update).updateSections(this.collectUpdateSections()).skipTag(this.composite.autoConfig.skipTag).skipRelease(this.composite.autoConfig.skipRelease).changelog(this.composite.autoConfig.changelog).changelogFormatted(this.composite.autoConfig.changelogFormatted).username(this.composite.autoConfig.username).commitAuthorName(this.composite.autoConfig.commitAuthorName).commitAuthorEmail(this.composite.autoConfig.commitAuthorEmail).signing(this.composite.autoConfig.signing).armored(this.composite.autoConfig.armored).files(this.collectEntries(this.composite.autoConfig.files)).globs(this.collectEntries(this.composite.autoConfig.globs)).selectedPlatforms(this.collectSelectedPlatforms()).autoConfigure();
        this.doExecute(context);
    }

    private Set<UpdateSection> collectUpdateSections() {
        LinkedHashSet<UpdateSection> set = new LinkedHashSet<UpdateSection>();
        if (this.composite.autoConfig.updateSections != null && this.composite.autoConfig.updateSections.length > 0) {
            for (String updateSection : this.composite.autoConfig.updateSections) {
                set.add(UpdateSection.of((String)updateSection.trim()));
            }
        }
        return set;
    }

    private void basedir() {
        Path path = this.actualBasedir = null != this.basedir ? this.basedir : Paths.get(".", new String[0]).normalize();
        if (!Files.exists(this.actualBasedir, new LinkOption[0])) {
            throw this.halt(this.$("ERROR_missing_required_option", "--basedir=<basedir>"));
        }
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        Workflows.release((JReleaserContext)context).execute();
    }

    @Override
    protected boolean dryrun() {
        return this.dryrun;
    }

    private HaltExecutionException halt(String message) throws HaltExecutionException {
        this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(message));
        this.spec.commandLine().usage(this.parent.out);
        throw new HaltExecutionException();
    }

    static class AutoConfigGroup {
        @CommandLine.Option(names={"--auto-config"})
        boolean autoConfig;
        @CommandLine.Option(names={"--project-name"})
        String projectName;
        @CommandLine.Option(names={"--project-version"})
        String projectVersion;
        @CommandLine.Option(names={"--project-version-pattern"})
        String projectVersionPattern;
        @CommandLine.Option(names={"--project-snapshot-pattern"})
        String projectSnapshotPattern;
        @CommandLine.Option(names={"--project-snapshot-label"})
        String projectSnapshotLabel;
        @CommandLine.Option(names={"--project-snapshot-full-changelog"})
        boolean projectSnapshotFullChangelog;
        @CommandLine.Option(names={"--tag-name"})
        String tagName;
        @CommandLine.Option(names={"--previous-tag-name"})
        String previousTagName;
        @CommandLine.Option(names={"--release-name"})
        String releaseName;
        @CommandLine.Option(names={"--milestone-name"})
        String milestoneName;
        @CommandLine.Option(names={"--prerelease"})
        boolean prerelease;
        @CommandLine.Option(names={"--prerelease-pattern"})
        String prereleasePattern;
        @CommandLine.Option(names={"--draft"})
        boolean draft;
        @CommandLine.Option(names={"--overwrite"})
        boolean overwrite;
        @CommandLine.Option(names={"--update"})
        boolean update;
        @CommandLine.Option(names={"--update-section"}, paramLabel="<section>")
        String[] updateSections;
        @CommandLine.Option(names={"--skip-tag"})
        boolean skipTag;
        @CommandLine.Option(names={"--skip-release"})
        boolean skipRelease;
        @CommandLine.Option(names={"--branch"})
        String branch;
        @CommandLine.Option(names={"--changelog"})
        String changelog;
        @CommandLine.Option(names={"--changelog-formatted"})
        boolean changelogFormatted;
        @CommandLine.Option(names={"--username"})
        String username;
        @CommandLine.Option(names={"--commit-author-name"})
        String commitAuthorName;
        @CommandLine.Option(names={"--commit-author-email"})
        String commitAuthorEmail;
        @CommandLine.Option(names={"--signing-enabled"})
        boolean signing;
        @CommandLine.Option(names={"--signing-armored"})
        boolean armored;
        @CommandLine.Option(names={"--file"}, paramLabel="<file>")
        String[] files;
        @CommandLine.Option(names={"--glob"}, paramLabel="<glob>")
        String[] globs;

        AutoConfigGroup() {
        }
    }

    static class Exclude {
        @CommandLine.Option(names={"-xd", "--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;
        @CommandLine.ArgGroup(exclusive=false, order=3, headingKey="auto-config.header")
        AutoConfigGroup autoConfig;

        Composite() {
        }

        String[] includedDistributions() {
            return this.include != null ? this.include.includedDistributions : null;
        }

        String[] excludedDistributions() {
            return this.exclude != null ? this.exclude.excludedDistributions : null;
        }

        boolean autoConfig() {
            return this.autoConfig != null && this.autoConfig.autoConfig;
        }
    }
}

