/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Docker;
import org.jreleaser.model.DockerConfiguration;
import org.jreleaser.model.DockerSpec;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Registry;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;
import org.jreleaser.util.command.Command;

public class DockerPackagerProcessor
extends AbstractRepositoryPackagerProcessor<Docker> {
    private static final String ROOT = "ROOT";

    public DockerPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props, String distributionName, Path prepareDirectory, String templateDirectory, String packagerName, boolean copyLicense) throws IOException, PackagerProcessingException {
        if (((Docker)this.packager).getActiveSpecs().isEmpty()) {
            super.doPrepareDistribution(distribution, props, distributionName, prepareDirectory, templateDirectory, packagerName, true);
            if (!((Docker)this.packager).isUseLocalArtifact()) {
                Files.move(prepareDirectory.resolve("Dockerfile-remote"), prepareDirectory.resolve("Dockerfile"), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.deleteIfExists(prepareDirectory.resolve("Dockerfile-remote"));
            }
            return;
        }
        String rootTemplateDirectory = ((Docker)this.getPackager()).getTemplateDirectory() + File.separator + ROOT;
        super.doPrepareDistribution(distribution, props, distributionName, prepareDirectory.resolve(ROOT), rootTemplateDirectory, ((Docker)this.packager).getType(), false);
        Files.deleteIfExists(prepareDirectory.resolve(ROOT).resolve("Dockerfile"));
        Files.deleteIfExists(prepareDirectory.resolve(ROOT).resolve("Dockerfile-remote"));
        for (DockerSpec spec : ((Docker)this.packager).getActiveSpecs()) {
            this.prepareSpec(distribution, props, distributionName, prepareDirectory, spec);
        }
    }

    private void prepareSpec(Distribution distribution, Map<String, Object> props, String distributionName, Path prepareDirectory, DockerSpec spec) throws IOException, PackagerProcessingException {
        Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
        this.context.getLogger().debug(RB.$((String)"distributions.action.preparing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
        super.doPrepareDistribution(distribution, newProps, distributionName, prepareDirectory.resolve(spec.getName()), spec.getTemplateDirectory(), spec.getName() + "/" + ((Docker)this.packager).getType(), false);
        if (!spec.isUseLocalArtifact()) {
            Files.move(prepareDirectory.resolve(spec.getName()).resolve("Dockerfile-remote"), prepareDirectory.resolve(spec.getName()).resolve("Dockerfile"), StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.deleteIfExists(prepareDirectory.resolve(spec.getName()).resolve("Dockerfile-remote"));
        }
    }

    private Map<String, Object> fillSpecProps(Distribution distribution, Map<String, Object> props, DockerSpec spec) throws PackagerProcessingException {
        List<Artifact> artifacts = Collections.singletonList(spec.getArtifact());
        Map<String, Object> newProps = this.fillProps(distribution, props);
        newProps.put("dockerSpecName", spec.getName());
        this.fillDockerProperties(newProps, distribution, (DockerConfiguration)spec);
        this.verifyAndAddArtifacts(newProps, distribution, artifacts);
        Path prepareDirectory = (Path)newProps.get("distributionPrepareDirectory");
        newProps.put("distributionPrepareDirectory", prepareDirectory.resolve(spec.getName()));
        Path packageDirectory = (Path)newProps.get("distributionPackageDirectory");
        newProps.put("distributionPackageDirectory", packageDirectory.resolve(spec.getName()));
        return newProps;
    }

    @Override
    protected boolean verifyAndAddArtifacts(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        if (((Docker)this.packager).getActiveSpecs().isEmpty()) {
            return super.verifyAndAddArtifacts(props, distribution);
        }
        return true;
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        if (((Docker)this.packager).getActiveSpecs().isEmpty()) {
            List artifacts = ((Docker)this.packager).resolveCandidateArtifacts(this.context, distribution);
            this.packageDocker(distribution, props, packageDirectory, (DockerConfiguration)this.getPackager(), artifacts);
            return;
        }
        Path rootPrepareDirectory = this.getPrepareDirectory(props).resolve(ROOT);
        Path rootPackageDirectory = this.getPackageDirectory(props).resolve(ROOT);
        this.copyFiles(rootPrepareDirectory, rootPackageDirectory);
        for (DockerSpec spec : ((Docker)this.packager).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.packaging", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
            this.packageDocker(distribution, newProps, packageDirectory.resolve(spec.getName()), (DockerConfiguration)spec, Collections.singletonList(spec.getArtifact()));
        }
    }

    protected void packageDocker(Distribution distribution, Map<String, Object> props, Path packageDirectory, DockerConfiguration docker, List<Artifact> artifacts) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        try {
            Path workingDirectory = this.prepareAssembly(distribution, props, packageDirectory, artifacts);
            for (String imageName : docker.getImageNames()) {
                imageName = Templates.resolveTemplate((String)imageName, props);
                Command cmd = this.createBuildCommand(props, docker);
                if (!cmd.hasArg("-q") && !cmd.hasArg("--quiet")) {
                    cmd.arg("-q");
                }
                cmd.arg("-f");
                cmd.arg(workingDirectory.resolve("Dockerfile").toAbsolutePath().toString());
                cmd.arg("-t");
                cmd.arg(imageName);
                cmd.arg(workingDirectory.toAbsolutePath().toString());
                this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
                this.context.getLogger().info(" - {}", new Object[]{imageName});
                this.executeCommand(cmd);
            }
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    private Path prepareAssembly(Distribution distribution, Map<String, Object> props, Path packageDirectory, List<Artifact> artifacts) throws IOException, PackagerProcessingException {
        this.copyPreparedFiles(distribution, props);
        Path assemblyDirectory = packageDirectory.resolve("assembly");
        Files.createDirectories(assemblyDirectory, new FileAttribute[0]);
        for (Artifact artifact : artifacts) {
            Path artifactPath = artifact.getEffectivePath(this.context, distribution);
            if (distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE) {
                if (artifactPath.toString().endsWith(".zip")) {
                    FileUtils.unpackArchive((Path)artifactPath, (Path)assemblyDirectory);
                    continue;
                }
                Files.copy(artifactPath, assemblyDirectory.resolve(artifactPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            Files.copy(artifactPath, assemblyDirectory.resolve(artifactPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        return packageDirectory;
    }

    private Command createBuildCommand(Map<String, Object> props, DockerConfiguration docker) {
        Command cmd = this.createCommand("build");
        for (int i = 0; i < docker.getBuildArgs().size(); ++i) {
            String arg = (String)docker.getBuildArgs().get(i);
            if (arg.contains("{{")) {
                cmd.arg(Templates.resolveTemplate((String)arg, props));
                continue;
            }
            cmd.arg(arg);
        }
        return cmd;
    }

    private Command createCommand(String name) {
        return new Command("docker" + (PlatformUtils.isWindows() ? ".exe" : "")).arg("-l").arg("error").arg(name);
    }

    @Override
    public void publishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        if (((Docker)this.packager).getActiveSpecs().isEmpty()) {
            if (((Docker)this.packager).getRegistries().isEmpty()) {
                this.context.getLogger().info(RB.$((String)"docker.no.registries", (Object[])new Object[0]));
                this.publishToRepository(distribution, props);
                return;
            }
            super.publishDistribution(distribution, props);
            this.publishToRepository(distribution, props);
            return;
        }
        for (DockerSpec spec : ((Docker)this.packager).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.publishing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
            this.publishDocker(distribution, newProps, (DockerConfiguration)spec);
        }
        this.publishToRepository(distribution, props);
    }

    private void publishToRepository(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        super.doPublishDistribution(distribution, this.fillProps(distribution, props));
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        this.publishDocker(distribution, props, (DockerConfiguration)this.getPackager());
    }

    protected void publishDocker(Distribution distribution, Map<String, Object> props, DockerConfiguration docker) throws PackagerProcessingException {
        for (Registry registry : docker.getRegistries()) {
            this.login(registry);
            for (String imageName : docker.getImageNames()) {
                this.publish(registry, imageName, props);
            }
            this.logout(registry);
        }
    }

    private void login(Registry registry) throws PackagerProcessingException {
        Command cmd = this.createCommand("login");
        if (StringUtils.isNotBlank((String)registry.getServer())) {
            cmd.arg(registry.getServer());
        }
        cmd.arg("-u");
        cmd.arg(registry.getResolvedUsername());
        cmd.arg("-p");
        cmd.arg(registry.getResolvedPassword());
        ByteArrayInputStream in = new ByteArrayInputStream((registry.getResolvedPassword() + System.lineSeparator()).getBytes());
        this.context.getLogger().debug(RB.$((String)"docker.login", (Object[])new Object[0]), new Object[]{registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommandWithInput(cmd, in);
        }
    }

    private void publish(Registry registry, String imageName, Map<String, Object> props) throws PackagerProcessingException {
        int pos;
        String tag = imageName = Templates.resolveTemplate((String)imageName, props);
        String serverName = registry.getServerName();
        String server = registry.getServer();
        String repositoryName = registry.getRepositoryName();
        if ("DEFAULT".equals(serverName)) {
            if (!tag.startsWith(repositoryName)) {
                pos = tag.indexOf("/");
                tag = pos < 0 ? repositoryName + "/" + tag : repositoryName + tag.substring(pos);
            }
        } else if (!tag.startsWith(server)) {
            pos = tag.indexOf("/");
            tag = pos < 0 ? server + "/" + repositoryName + "/" + tag : server + "/" + repositoryName + tag.substring(pos);
        }
        if (!tag.equals(imageName)) {
            Command cmd = this.createCommand("tag").arg(imageName).arg(tag);
            this.context.getLogger().debug(RB.$((String)"docker.tag", (Object[])new Object[0]), new Object[]{imageName, tag});
            if (!this.context.isDryrun()) {
                this.executeCommand(cmd);
            }
        }
        Command cmd = this.createCommand("push").arg("-q").arg(tag);
        this.context.getLogger().info(" - {}", new Object[]{tag});
        this.context.getLogger().debug(RB.$((String)"docker.push", (Object[])new Object[0]), new Object[]{tag, registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommand(cmd);
        }
    }

    private void logout(Registry registry) throws PackagerProcessingException {
        Command cmd = this.createCommand("logout");
        if (StringUtils.isNotBlank((String)registry.getServer())) {
            cmd.arg(registry.getServerName());
        }
        this.context.getLogger().debug(RB.$((String)"docker.logout", (Object[])new Object[0]), new Object[]{registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommand(cmd);
        }
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        this.fillDockerProperties(props, distribution, (DockerConfiguration)this.getPackager());
    }

    protected void fillDockerProperties(Map<String, Object> props, Distribution distribution, DockerConfiguration docker) throws PackagerProcessingException {
        props.put("dockerBaseImage", Templates.resolveTemplate((String)docker.getBaseImage(), props));
        ArrayList labels = new ArrayList();
        docker.getLabels().forEach((label, value) -> labels.add(MustacheUtils.passThrough((String)("\"" + label + "\"=\"" + Templates.resolveTemplate((String)value, (Map)props) + "\""))));
        props.put("dockerLabels", labels);
        props.put("dockerPreCommands", docker.getPreCommands().stream().map(c -> MustacheUtils.passThrough((String)Templates.resolveTemplate((String)c, (Map)props))).collect(Collectors.toList()));
        props.put("dockerPostCommands", docker.getPostCommands().stream().map(c -> MustacheUtils.passThrough((String)Templates.resolveTemplate((String)c, (Map)props))).collect(Collectors.toList()));
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "executable".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("assembly").resolve(distribution.getExecutable()) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected void prepareWorkingCopy(Map<String, Object> props, Path directory, Distribution distribution) throws PackagerProcessingException, IOException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        List activeSpecs = ((Docker)this.packager).getActiveSpecs();
        if (activeSpecs.isEmpty()) {
            for (String imageName : ((Docker)this.packager).getImageNames()) {
                this.copyDockerfiles(packageDirectory, Templates.resolveTemplate((String)imageName, props), directory, (DockerConfiguration)this.packager, false);
            }
        } else {
            this.prepareWorkingCopy(packageDirectory.resolve(ROOT), directory);
            for (DockerSpec spec : activeSpecs) {
                Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
                for (String imageName : spec.getImageNames()) {
                    this.copyDockerfiles(packageDirectory.resolve(spec.getName()), Templates.resolveTemplate((String)imageName, newProps), directory, (DockerConfiguration)spec, true);
                }
            }
        }
    }

    private void copyDockerfiles(Path source, String imageName, Path directory, DockerConfiguration docker, boolean isSpec) throws IOException {
        Path destination = directory;
        String[] parts = imageName.split("/");
        parts = parts[parts.length - 1].split(":");
        if (isSpec) {
            destination = directory.resolve(parts[0]);
        }
        if (((Docker)this.packager).getRepository().isVersionedSubfolders()) {
            destination = directory.resolve(parts[1]);
        }
        Path assembly = destination.resolve("assembly");
        FileUtils.deleteFiles((Path)assembly);
        Files.createDirectories(destination, new FileAttribute[0]);
        this.prepareWorkingCopy(source, destination, (Path path) -> !docker.isUseLocalArtifact() && "assembly".equals(path.getFileName().toString()));
    }
}

