/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class RepeatableInputStream
extends InputStream {
    private final InputStream delegate;
    private final int bufferSize;
    private int bufferOffset = 0;
    private long bytesReadPastMark = 0L;
    private byte[] buffer;

    public RepeatableInputStream(InputStream inputStream, int bufferSize) {
        this.delegate = Objects.requireNonNull(inputStream, "'inputStream' must not be null");
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
    }

    public RepeatableInputStream(InputStream inputStream) {
        this(inputStream, 131072);
    }

    @Override
    public void reset() throws IOException {
        if (this.bytesReadPastMark > (long)this.bufferSize) {
            throw new IOException("Cannot reset as " + this.bytesReadPastMark + "bytes have been written, more than current buffer size of" + this.bufferSize);
        }
        this.bufferOffset = 0;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.bytesReadPastMark <= (long)this.bufferSize && this.buffer != null) {
            byte[] newBuffer = new byte[this.bufferSize];
            System.arraycopy(this.buffer, this.bufferOffset, newBuffer, 0, (int)(this.bytesReadPastMark - (long)this.bufferOffset));
            this.buffer = newBuffer;
            this.bytesReadPastMark -= (long)this.bufferOffset;
            this.bufferOffset = 0;
        } else {
            this.bufferOffset = 0;
            this.bytesReadPastMark = 0L;
            this.buffer = new byte[this.bufferSize];
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] tmp = new byte[len];
        if ((long)this.bufferOffset < this.bytesReadPastMark && this.buffer != null) {
            int bytesFromBuffer = tmp.length;
            if ((long)(this.bufferOffset + bytesFromBuffer) > this.bytesReadPastMark) {
                bytesFromBuffer = (int)this.bytesReadPastMark - this.bufferOffset;
            }
            System.arraycopy(this.buffer, this.bufferOffset, b, off, bytesFromBuffer);
            this.bufferOffset += bytesFromBuffer;
            return bytesFromBuffer;
        }
        int count = this.delegate.read(tmp);
        if (count <= 0) {
            return count;
        }
        if (this.bytesReadPastMark + (long)count <= (long)this.bufferSize) {
            System.arraycopy(tmp, 0, this.buffer, (int)this.bytesReadPastMark, count);
            this.bufferOffset += count;
        } else if (this.buffer != null) {
            this.buffer = null;
        }
        System.arraycopy(tmp, 0, b, off, count);
        this.bytesReadPastMark += (long)count;
        return count;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count = this.read(tmp);
        if (count != -1) {
            return tmp[0];
        }
        return count;
    }
}

