/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import org.jreleaser.bundle.RB;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModelPrinter;
import org.jreleaser.util.Errors;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.PlatformUtils;

public class ModelValidator {
    public static void validate(JReleaserContext context) {
        try {
            Errors errors = context.validateModel();
            if (context.getMode() != JReleaserContext.Mode.CHANGELOG) {
                new JReleaserModelPrinter.Plain(context.getLogger().getTracer()).print((Object)context.getModel().asMap(true));
            }
            switch (context.getMode()) {
                case ASSEMBLE: {
                    if (errors.hasConfigurationErrors()) {
                        throw new JReleaserException(RB.$((String)"ERROR_context_configurer_jreleaser_misconfigured", (Object[])new Object[0]) + System.lineSeparator() + errors.asString());
                    }
                    break;
                }
                default: {
                    if (errors.hasErrors()) {
                        throw new JReleaserException(RB.$((String)"ERROR_context_configurer_jreleaser_misconfigured", (Object[])new Object[0]) + System.lineSeparator() + errors.asString());
                    }
                }
            }
        }
        catch (JReleaserException e) {
            context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException(RB.$((String)"ERROR_context_configurer_jreleaser_misconfigured", (Object[])new Object[0]), (Throwable)e);
        }
        if (context.getMode() != JReleaserContext.Mode.ASSEMBLE) {
            context.setReleaser(Releasers.releaserFor(context));
        }
        ModelValidator.report(context);
    }

    private static void report(JReleaserContext context) {
        String version = context.getModel().getProject().getVersion();
        context.getModel().getProject().parseVersion();
        context.getLogger().info(RB.$((String)"context.creator.report.project-version", (Object[])new Object[0]), new Object[]{version});
        context.getLogger().info(RB.$((String)"context.creator.report.release", (Object[])new Object[0]), new Object[]{context.getModel().getProject().isSnapshot() ? " " : " " + RB.$((String)"not", (Object[])new Object[0]) + " "});
        context.getLogger().info(RB.$((String)"context.creator.report.timestamp", (Object[])new Object[0]), new Object[]{context.getModel().getTimestamp()});
        if (context.getModel().getCommit() != null) {
            context.getLogger().info(RB.$((String)"context.creator.report.head", (Object[])new Object[0]), new Object[]{context.getModel().getCommit().getShortHash()});
        }
        context.getLogger().info(RB.$((String)"context.creator.report.platform", (Object[])new Object[0]), new Object[]{PlatformUtils.getCurrentFull()});
    }
}

