/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.Sdkman;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class SdkmanAnnouncer
extends AbstractAnnouncer {
    public static final String NAME = "sdkman";
    private String consumerKey;
    private String consumerToken;
    private String candidate;
    private String releaseNotesUrl;
    private String downloadUrl;
    private Sdkman.Command command;

    public SdkmanAnnouncer() {
        super(NAME);
    }

    void setAll(SdkmanAnnouncer sdkman) {
        super.setAll(sdkman);
        this.consumerKey = sdkman.consumerKey;
        this.consumerToken = sdkman.consumerToken;
        this.candidate = sdkman.candidate;
        this.releaseNotesUrl = sdkman.releaseNotesUrl;
        this.downloadUrl = sdkman.downloadUrl;
        this.command = sdkman.command;
    }

    @Override
    public boolean isSnapshotSupported() {
        return false;
    }

    public String getResolvedConsumerKey() {
        return Env.resolve((String)"SDKMAN_CONSUMER_KEY", (String)this.consumerKey);
    }

    public String getResolvedConsumerToken() {
        return Env.resolve((String)"SDKMAN_CONSUMER_TOKEN", (String)this.consumerToken);
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerToken() {
        return this.consumerToken;
    }

    public void setConsumerToken(String consumerToken) {
        this.consumerToken = consumerToken;
    }

    public String getCandidate() {
        return this.candidate;
    }

    public void setCandidate(String candidate) {
        this.candidate = candidate;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Sdkman.Command getCommand() {
        return this.command;
    }

    public void setCommand(Sdkman.Command command) {
        this.command = command;
    }

    public void setCommand(String str) {
        this.command = Sdkman.Command.of(str);
    }

    public boolean isCommandSet() {
        return this.command != null;
    }

    public boolean isMajor() {
        return this.command == Sdkman.Command.MAJOR;
    }

    @Deprecated
    public void setMajor(boolean major) {
        System.out.println("announce.sdkman.major has been deprecated since 0.6.0 and will be removed in the future. Use announce.sdkman.command instead");
        this.command = major ? Sdkman.Command.MAJOR : Sdkman.Command.MINOR;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("consumerKey", StringUtils.isNotBlank((String)this.getResolvedConsumerKey()) ? "************" : "**unset**");
        props.put("consumerToken", StringUtils.isNotBlank((String)this.getResolvedConsumerToken()) ? "************" : "**unset**");
        props.put("candidate", this.candidate);
        props.put("releaseNotesUrl", this.releaseNotesUrl);
        props.put("downloadUrl", this.downloadUrl);
        props.put("command", (Object)this.command);
    }
}

