/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHAppCreateTokenBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositorySelection;
import org.kohsuke.github.GHTargetType;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SearchResult;
import org.kohsuke.github.internal.Previews;

public class GHAppInstallation
extends GHObject {
    private GHUser account;
    @JsonProperty(value="access_tokens_url")
    private String accessTokenUrl;
    @JsonProperty(value="repositories_url")
    private String repositoriesUrl;
    @JsonProperty(value="app_id")
    private long appId;
    @JsonProperty(value="target_id")
    private long targetId;
    @JsonProperty(value="target_type")
    private GHTargetType targetType;
    private Map<String, GHPermissionType> permissions;
    private List<GHEvent> events;
    @JsonProperty(value="single_file_name")
    private String singleFileName;
    @JsonProperty(value="repository_selection")
    private GHRepositorySelection repositorySelection;
    private String htmlUrl;

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    @Override
    public GitHub getRoot() {
        return this.root;
    }

    @Deprecated
    public void setRoot(GitHub root) {
        this.root = root;
    }

    public GHUser getAccount() {
        return this.account;
    }

    @Deprecated
    public void setAccount(GHUser account) {
        this.account = account;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    @Deprecated
    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getRepositoriesUrl() {
        return this.repositoriesUrl;
    }

    @Preview(value={Previews.MACHINE_MAN})
    @Deprecated
    public PagedSearchIterable<GHRepository> listRepositories() {
        GitHubRequest request;
        try {
            request = ((Requester)((Requester)this.root.createRequest().withPreview(Previews.MACHINE_MAN)).withUrlPath("/installation/repositories", new String[0])).build();
        }
        catch (MalformedURLException e) {
            throw new GHException("", e);
        }
        return new PagedSearchIterable<GHRepository>(this.root, request, GHAppInstallationRepositoryResult.class);
    }

    @Deprecated
    public void setRepositoriesUrl(String repositoriesUrl) {
        this.repositoriesUrl = repositoriesUrl;
    }

    public long getAppId() {
        return this.appId;
    }

    @Deprecated
    public void setAppId(long appId) {
        this.appId = appId;
    }

    public long getTargetId() {
        return this.targetId;
    }

    @Deprecated
    public void setTargetId(long targetId) {
        this.targetId = targetId;
    }

    public GHTargetType getTargetType() {
        return this.targetType;
    }

    @Deprecated
    public void setTargetType(GHTargetType targetType) {
        this.targetType = targetType;
    }

    public Map<String, GHPermissionType> getPermissions() {
        return this.permissions;
    }

    @Deprecated
    public void setPermissions(Map<String, GHPermissionType> permissions) {
        this.permissions = permissions;
    }

    public List<GHEvent> getEvents() {
        return this.events;
    }

    @Deprecated
    public void setEvents(List<GHEvent> events) {
        this.events = events;
    }

    public String getSingleFileName() {
        return this.singleFileName;
    }

    @Deprecated
    public void setSingleFileName(String singleFileName) {
        this.singleFileName = singleFileName;
    }

    public GHRepositorySelection getRepositorySelection() {
        return this.repositorySelection;
    }

    @Deprecated
    public void setRepositorySelection(GHRepositorySelection repositorySelection) {
        this.repositorySelection = repositorySelection;
    }

    GHAppInstallation wrapUp(GitHub root) {
        this.root = root;
        return this;
    }

    @Preview(value={Previews.GAMBIT})
    @Deprecated
    public void deleteInstallation() throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("DELETE")).withPreview(Previews.GAMBIT)).withUrlPath(String.format("/app/installations/%d", this.getId()), new String[0])).send();
    }

    @BetaApi
    @Deprecated
    public GHAppCreateTokenBuilder createToken(Map<String, GHPermissionType> permissions) {
        return new GHAppCreateTokenBuilder(this.root, String.format("/app/installations/%d/access_tokens", this.getId()), permissions);
    }

    @BetaApi
    @Deprecated
    public GHAppCreateTokenBuilder createToken() {
        return new GHAppCreateTokenBuilder(this.root, String.format("/app/installations/%d/access_tokens", this.getId()));
    }

    private static class GHAppInstallationRepositoryResult
    extends SearchResult<GHRepository> {
        private GHRepository[] repositories;

        private GHAppInstallationRepositoryResult() {
        }

        GHRepository[] getItems(GitHub root) {
            for (GHRepository item : this.repositories) {
                item.wrap(root);
            }
            return this.repositories;
        }
    }
}

