/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Artifactory;
import org.jreleaser.model.Checksum;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Signing;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.uploader.spi.ArtifactUploader;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public abstract class AbstractArtifactUploader<U extends Uploader>
implements ArtifactUploader<U> {
    protected final JReleaserContext context;

    protected AbstractArtifactUploader(JReleaserContext context) {
        this.context = context;
    }

    protected List<Artifact> collectArtifacts() {
        boolean uploadChecksums;
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        List keys = this.getUploader().resolveSkipKeys();
        Checksum checksum = this.context.getModel().getChecksum();
        boolean bl = uploadChecksums = this.getUploader().isChecksums() != false && !(this.getUploader() instanceof Artifactory);
        if (this.getUploader().isFiles().booleanValue()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)this.context)) {
                if (!artifact.isActive()) continue;
                Path path = artifact.getEffectivePath(this.context);
                if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                artifacts.add(artifact);
                if (!uploadChecksums || !this.isIndividual(this.context, artifact) || artifact.extraPropertyIsTrue("skipChecksum")) continue;
                for (Algorithm algorithm : checksum.getAlgorithms()) {
                    artifacts.add(Artifact.of((Path)this.context.getChecksumsDirectory().resolve(path.getFileName() + "." + algorithm.formatted())));
                }
            }
        }
        if (this.getUploader().isArtifacts().booleanValue()) {
            for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
                if (this.isSkip((ExtraProperties)distribution, keys)) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActive()) continue;
                    Path path = artifact.getEffectivePath(this.context, distribution);
                    if (this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                    String platform = artifact.getPlatform();
                    String platformReplaced = distribution.getPlatform().applyReplacements(platform);
                    if (StringUtils.isNotBlank((String)platformReplaced)) {
                        artifact.getExtraProperties().put("platformReplaced", platformReplaced);
                    }
                    artifacts.add(artifact);
                    if (!uploadChecksums || !this.isIndividual(this.context, distribution, artifact)) continue;
                    for (Algorithm algorithm : checksum.getAlgorithms()) {
                        artifacts.add(Artifact.of((Path)this.context.getChecksumsDirectory().resolve(distribution.getName()).resolve(path.getFileName() + "." + algorithm.formatted())));
                    }
                }
            }
        }
        if (uploadChecksums) {
            for (Algorithm algorithm : checksum.getAlgorithms()) {
                Path checksums = this.context.getChecksumsDirectory().resolve(checksum.getResolvedName(this.context, algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                artifacts.add(Artifact.of((Path)checksums));
            }
        }
        Signing signing = this.context.getModel().getSigning();
        if (this.getUploader().isSignatures().booleanValue() && signing.isEnabled()) {
            String extension = signing.getSignatureExtension();
            ArrayList<Artifact> signatures = new ArrayList<Artifact>();
            for (Artifact artifact : artifacts) {
                Path signaturePath;
                if (artifact.extraPropertyIsTrue("skipSigning") || !Files.exists(signaturePath = this.context.getSignaturesDirectory().resolve(artifact.getEffectivePath(this.context).getFileName() + extension), new LinkOption[0]) || 0L == signaturePath.toFile().length()) continue;
                signatures.add(Artifact.of((Path)signaturePath, (Map)artifact.getExtraProperties()));
            }
            if (!signatures.isEmpty() && signing.getMode() == Signing.Mode.COSIGN) {
                Path publicKeyFile = signing.getCosign().getResolvedPublicKeyFilePath(this.context);
                signatures.add(Artifact.of((Path)publicKeyFile));
            }
            artifacts.addAll(signatures);
        }
        return artifacts;
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isIndividual(JReleaserContext context, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(artifact.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }

    private boolean isIndividual(JReleaserContext context, Distribution distribution, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(artifact.getExtraProperties().get("individualChecksum"));
        }
        if (distribution.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue(distribution.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }
}

