/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class NativeImageResolver
extends Validator {
    public static void resolveNativeImageOutputs(JReleaserContext context, Errors errors) {
        context.getLogger().debug("nativeImage");
        for (NativeImage nativeImage : context.getModel().getAssemble().getActiveNativeImages()) {
            if (!nativeImage.isExported()) continue;
            NativeImageResolver.resolveNativeImageOutputs(context, nativeImage, errors);
        }
    }

    private static void resolveNativeImageOutputs(JReleaserContext context, NativeImage nativeImage, Errors errors) {
        if (!context.isPlatformSelected(nativeImage.getGraal())) {
            return;
        }
        String imageName = nativeImage.getResolvedImageName(context);
        if (StringUtils.isNotBlank((String)nativeImage.getImageNameTransform())) {
            imageName = nativeImage.getResolvedImageNameTransform(context);
        }
        String platform = nativeImage.getGraal().getPlatform();
        String platformReplaced = nativeImage.getPlatform().applyReplacements(platform);
        Path image = context.getAssembleDirectory().resolve(nativeImage.getName()).resolve(nativeImage.getType()).resolve(imageName + "-" + platformReplaced + "." + nativeImage.getArchiveFormat().extension());
        if (!Files.exists(image, new LinkOption[0])) {
            errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{nativeImage.getType(), nativeImage.getName(), nativeImage.getName()}));
        } else {
            Artifact artifact = Artifact.of(image, platform);
            artifact.setExtraProperties(nativeImage.getExtraProperties());
            artifact.activate();
            nativeImage.addOutput(artifact);
        }
    }
}

