/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Chocolatey
extends AbstractRepositoryPackager<Chocolatey> {
    public static final String CHOCOLATEY_API_KEY = "CHOCOLATEY_API_KEY";
    public static final String TYPE = "chocolatey";
    public static final String SKIP_CHOCOLATEY = "skipChocolatey";
    public static final String DEFAULT_CHOCOLATEY_PUSH_URL = "https://push.chocolatey.org/";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final ChocolateyBucket bucket = new ChocolateyBucket();
    private String packageName;
    private String packageVersion;
    private String username;
    private String apiKey;
    private String title;
    private String iconUrl;
    private String source;
    private Boolean remoteBuild;

    public Chocolatey() {
        super(TYPE);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.bucket.freeze();
    }

    @Override
    public void merge(Chocolatey choco) {
        this.freezeCheck();
        super.merge(choco);
        this.packageName = this.merge(this.packageName, choco.packageName);
        this.packageVersion = this.merge(this.packageVersion, choco.packageVersion);
        this.username = this.merge(this.username, choco.username);
        this.apiKey = this.merge(this.apiKey, choco.apiKey);
        this.title = this.merge(this.title, choco.title);
        this.iconUrl = this.merge(this.iconUrl, choco.iconUrl);
        this.source = this.merge(this.source, choco.source);
        this.remoteBuild = this.merge(this.remoteBuild, choco.remoteBuild);
        this.setBucket(choco.bucket);
    }

    public String getResolvedApiKey() {
        return Env.env((String)CHOCOLATEY_API_KEY, (String)this.apiKey);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.freezeCheck();
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.freezeCheck();
        this.packageVersion = packageVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.freezeCheck();
        this.username = username;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.freezeCheck();
        this.apiKey = apiKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.freezeCheck();
        this.title = title;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.freezeCheck();
        this.iconUrl = iconUrl;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.freezeCheck();
        this.source = source;
    }

    public boolean isRemoteBuild() {
        return this.remoteBuild != null && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.freezeCheck();
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return this.remoteBuild != null;
    }

    public ChocolateyBucket getBucket() {
        return this.bucket;
    }

    public void setBucket(ChocolateyBucket bucket) {
        this.freezeCheck();
        this.bucket.merge(bucket);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("packageVersion", this.packageVersion);
        props.put("username", this.username);
        props.put("apiKey", StringUtils.isNotBlank((String)this.getResolvedApiKey()) ? "************" : "**unset**");
        props.put("remoteBuild", this.isRemoteBuild());
        props.put("title", this.title);
        props.put("iconUrl", this.iconUrl);
        props.put("source", this.source);
        props.put("bucket", this.bucket.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.bucket;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform) && PlatformUtils.isIntel((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_CHOCOLATEY));
    }

    static {
        Set extensions = CollectionUtils.newSet((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.newSet((Object[])new String[]{FileType.EXE.extension(), FileType.MSI.extension()}));
    }

    public static class ChocolateyBucket
    extends AbstractRepositoryTap<ChocolateyBucket> {
        public ChocolateyBucket() {
            super(Chocolatey.TYPE, "chocolatey-bucket");
        }
    }
}

