/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.FtpDownloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class FtpDownloaderValidator
extends Validator {
    public static void validateFtpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("ftp");
        Map<String, FtpDownloader> ftp = context.getModel().getDownload().getFtp();
        for (Map.Entry<String, FtpDownloader> e : ftp.entrySet()) {
            e.getValue().setName(e.getKey());
            FtpDownloaderValidator.validateFtp(context, mode, e.getValue(), errors);
        }
    }

    private static void validateFtp(JReleaserContext context, JReleaserContext.Mode mode, FtpDownloader ftp, Errors errors) {
        context.getLogger().debug("ftp.{}", new Object[]{ftp.getName()});
        if (!ftp.isActiveSet()) {
            ftp.setActive(Active.ALWAYS);
        }
        if (!ftp.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        ftp.setUsername(FtpDownloaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_USERNAME", "ftp.username", ftp.getUsername(), errors, true));
        ftp.setPassword(FtpDownloaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_PASSWORD", "ftp.password", ftp.getPassword(), errors, true));
        ftp.setHost(FtpDownloaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_HOST", "ftp.host", ftp.getHost(), errors, context.isDryrun()));
        ftp.setPort(FtpDownloaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_PORT", "ftp.port", ftp.getPort(), errors, context.isDryrun()));
        FtpDownloaderValidator.validateTimeout(ftp);
        if (ftp.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"ftp." + ftp.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : ftp.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"ftp." + ftp.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

