/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.nexus2;

import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.nexus2.Nexus2;
import org.jreleaser.sdk.nexus2.Nexus2Exception;
import org.jreleaser.sdk.nexus2.api.NexusAPIException;
import org.jreleaser.util.StringUtils;

public class Nexus2MavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer, org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer deployer;

    public Nexus2MavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "nexus2";
    }

    public void deploy(String name) throws DeployException {
        Set deployables = this.collectDeployables();
        if (deployables.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        boolean isSnapshot = this.context.getModel().getProject().isSnapshot();
        String baseUrl = this.deployer.getResolvedUrl(this.context.fullProps());
        if (isSnapshot) {
            baseUrl = this.deployer.getResolvedSnapshotUrl(this.context.fullProps());
        }
        String username = this.deployer.getUsername();
        String password = this.deployer.getPassword();
        Nexus2 nexus = new Nexus2(this.context.getLogger(), baseUrl, username, password, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout(), this.context.isDryrun(), this.deployer.getTransitionDelay(), this.deployer.getTransitionMaxRetries());
        String groupId = this.context.getModel().getProject().getJava().getGroupId();
        String stagingProfileId = null;
        String stagingRepositoryId = null;
        if (!isSnapshot) {
            try {
                this.context.getLogger().info(RB.$((String)"nexus.lookup.staging.profile", (Object[])new Object[]{groupId}));
                stagingProfileId = nexus.findStagingProfileId(groupId);
                this.context.getAdditionalProperties().put(this.prefix("stagingProfileId"), stagingProfileId);
            }
            catch (Nexus2Exception e) {
                if (e.getCause() instanceof NexusAPIException) {
                    NexusAPIException ne = (NexusAPIException)e.getCause();
                    if (this.context.isDryrun()) {
                        if (ne.isUnauthorized() || ne.isForbidden()) {
                            this.context.getLogger().warn(RB.$((String)"ERROR_nexus_forbidden", (Object[])new Object[0]));
                        } else {
                            this.context.getLogger().warn(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}), (Throwable)e);
                        }
                    } else if (ne.isUnauthorized() || ne.isForbidden()) {
                        throw new DeployException(RB.$((String)"ERROR_nexus_forbidden", (Object[])new Object[0]), (Throwable)ne);
                    }
                    if (!this.context.isDryrun()) {
                        throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}), (Throwable)e);
                    }
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().warn(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}));
                }
                throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}), (Throwable)e);
            }
            if (!this.context.isDryrun()) {
                try {
                    this.context.getLogger().info(RB.$((String)"nexus.create.staging.repository", (Object[])new Object[]{groupId}));
                    stagingRepositoryId = nexus.createStagingRepository(stagingProfileId, groupId);
                    this.context.getAdditionalProperties().put(this.prefix("stagingRepositoryId"), stagingRepositoryId);
                }
                catch (Nexus2Exception e) {
                    this.context.getLogger().trace((Throwable)e);
                    throw new DeployException(RB.$((String)"ERROR_nexus_create_staging_repository", (Object[])new Object[]{groupId}), (Throwable)e);
                }
            }
        }
        for (Deployable deployable : deployables) {
            this.context.getLogger().info(" - {}", new Object[]{deployable.getFullDeployPath()});
            if (this.context.isDryrun()) continue;
            try {
                nexus.deploy(stagingRepositoryId, deployable.getDeployPath(), deployable.getLocalPath());
            }
            catch (Nexus2Exception e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{this.context.getBasedir().relativize(deployable.getLocalPath()), e.getMessage()}), (Throwable)e);
            }
        }
        if (!isSnapshot && !this.context.isDryrun() && this.deployer.isCloseRepository()) {
            try {
                this.context.getLogger().info(RB.$((String)"nexus.close.repository", (Object[])new Object[]{stagingRepositoryId}));
                this.context.getLogger().info(RB.$((String)"nexus.wait.operation", (Object[])new Object[0]));
                nexus.closeStagingRepository(stagingProfileId, stagingRepositoryId, groupId);
            }
            catch (Nexus2Exception e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_nexus_close_repository", (Object[])new Object[]{stagingRepositoryId}), (Throwable)e);
            }
        }
        if (!isSnapshot && !this.context.isDryrun() && this.deployer.isReleaseRepository()) {
            try {
                this.context.getLogger().info(RB.$((String)"nexus.release.repository", (Object[])new Object[]{stagingRepositoryId}));
                this.context.getLogger().info(RB.$((String)"nexus.wait.operation", (Object[])new Object[0]));
                nexus.releaseStagingRepository(stagingProfileId, stagingRepositoryId, groupId);
            }
            catch (Nexus2Exception e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_nexus_release_repository", (Object[])new Object[]{stagingRepositoryId}), (Throwable)e);
            }
        }
    }

    private String prefix(String input) {
        return "deploy" + StringUtils.capitalize((String)this.getDeployer().getType()) + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.getDeployer().getName()) + StringUtils.capitalize((String)input);
    }
}

