/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Map;
import java.util.Properties;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class Nexus2MavenDeployerValidator {
    private Nexus2MavenDeployerValidator() {
    }

    public static void validateNexus2MavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, Nexus2MavenDeployer> nexus2 = context.getModel().getDeploy().getMaven().getNexus2();
        if (!nexus2.isEmpty()) {
            context.getLogger().debug("deploy.maven.nexus2");
        }
        for (Map.Entry<String, Nexus2MavenDeployer> e : nexus2.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            Nexus2MavenDeployerValidator.validateNexus2MavenDeployer(context, e.getValue(), errors);
        }
    }

    private static void validateNexus2MavenDeployer(JReleaserContext context, Nexus2MavenDeployer mavenDeployer, Errors errors) {
        if (StringUtils.isNotBlank((String)mavenDeployer.getUrl()) && mavenDeployer.getUrl().contains("oss.sonatype.org") && !mavenDeployer.isApplyMavenCentralRulesSet()) {
            mavenDeployer.setApplyMavenCentralRules(true);
        }
        if (mavenDeployer.getTransitionDelay() <= 0) {
            mavenDeployer.setTransitionDelay(10);
        }
        if (mavenDeployer.getTransitionMaxRetries() <= 0) {
            mavenDeployer.setTransitionMaxRetries(60);
        }
        MavenDeployersValidator.validateMavenDeployer(context, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        if (context.getModel().getProject().isSnapshot()) {
            mavenDeployer.setSnapshotUrl(Validator.checkProperty(context, mavenDeployer.keysFor("snapshot.url"), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".snapshotUrl", mavenDeployer.getSnapshotUrl(), errors));
        }
        Properties vars = context.getModel().getEnvironment().getVars();
        mavenDeployer.setStagingProfileId(Env.resolve(mavenDeployer.keysFor("staging.profile.id"), (Properties)vars));
        mavenDeployer.setStagingRepositoryId(Env.resolve(mavenDeployer.keysFor("staging.repository.id"), (Properties)vars));
        mavenDeployer.setStartStage(Nexus2MavenDeployer.Stage.of((String)Env.resolve(mavenDeployer.keysFor("start.stage"), (Properties)vars)));
        mavenDeployer.setEndStage(Nexus2MavenDeployer.Stage.of((String)Env.resolve(mavenDeployer.keysFor("end.stage"), (Properties)vars)));
        try {
            Nexus2MavenDeployer.StageOperation.of((Nexus2MavenDeployer.Stage)mavenDeployer.getStartStage(), (Nexus2MavenDeployer.Stage)mavenDeployer.getEndStage());
        }
        catch (IllegalArgumentException e) {
            errors.configuration(e.getMessage());
        }
        if (StringUtils.isBlank((String)context.getModel().getProject().getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.groupId"}));
        }
    }
}

