/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.http;

import feign.form.FormData;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.HttpAnnouncers;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.StringUtils;

public class HttpAnnouncer
implements Announcer<org.jreleaser.model.api.announce.HttpAnnouncers> {
    private final JReleaserContext context;
    private final HttpAnnouncers https;

    public HttpAnnouncer(JReleaserContext context) {
        this.context = context;
        this.https = context.getModel().getAnnounce().getConfiguredHttp();
    }

    public org.jreleaser.model.api.announce.HttpAnnouncers getAnnouncer() {
        return this.https.asImmutable();
    }

    public String getName() {
        return "http";
    }

    public boolean isEnabled() {
        return this.https.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce() throws AnnounceException {
        Map http = this.https.getHttp();
        for (Map.Entry e : http.entrySet()) {
            if (!((org.jreleaser.model.internal.announce.HttpAnnouncer)e.getValue()).isEnabled()) continue;
            this.context.getLogger().setPrefix("http." + (String)e.getKey());
            try {
                this.announce((org.jreleaser.model.internal.announce.HttpAnnouncer)e.getValue());
            }
            catch (AnnounceException x) {
                this.context.getLogger().warn(x.getMessage().trim());
            }
            finally {
                this.context.getLogger().restorePrefix();
            }
        }
    }

    public void announce(org.jreleaser.model.internal.announce.HttpAnnouncer announcer) throws AnnounceException {
        String payload = "";
        if (StringUtils.isNotBlank((String)announcer.getPayload())) {
            payload = announcer.getResolvedPayload(this.context);
        } else {
            TemplateContext props = this.context.props();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            payload = announcer.getResolvedPayloadTemplate(this.context, props);
        }
        String resolvedUrl = announcer.getResolvedUrl(this.context);
        this.context.getLogger().info("url: {}", new Object[]{resolvedUrl});
        this.context.getLogger().debug("payload: {}", new Object[]{payload});
        if (this.context.isDryrun()) {
            return;
        }
        this.fireAnnouncerEvent(ExecutionEvent.before((String)JReleaserCommand.ANNOUNCE.toStep()), announcer);
        String username = announcer.getUsername();
        String password = announcer.getPassword();
        try {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            switch (announcer.resolveAuthorization()) {
                case NONE: {
                    break;
                }
                case BASIC: {
                    String auth = username + ":" + password;
                    byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
                    auth = new String(encodedAuth, StandardCharsets.UTF_8);
                    headers.put("Authorization", "Basic " + auth);
                    break;
                }
                case BEARER: {
                    headers.put("Authorization", announcer.getBearerKeyword() + " " + password);
                }
            }
            this.resolveHeaders(announcer, headers);
            FormData data = ClientUtils.toFormData((String)"payload", (String)headers.computeIfAbsent("Content-Type", k -> "text/plain"), (String)payload);
            if (announcer.getMethod() == Http.Method.POST) {
                ClientUtils.postFile((JReleaserLogger)this.context.getLogger(), (String)resolvedUrl, (int)announcer.getConnectTimeout(), (int)announcer.getReadTimeout(), (FormData)data, headers);
            } else {
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)resolvedUrl, (int)announcer.getConnectTimeout(), (int)announcer.getReadTimeout(), (FormData)data, headers);
            }
            this.fireAnnouncerEvent(ExecutionEvent.success((String)JReleaserCommand.ANNOUNCE.toStep()), announcer);
        }
        catch (UploadException e) {
            this.fireAnnouncerEvent(ExecutionEvent.failure((String)JReleaserCommand.ANNOUNCE.toStep(), (Throwable)e), announcer);
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException(e.getMessage(), (Throwable)e);
        }
    }

    private void resolveHeaders(org.jreleaser.model.internal.announce.HttpAnnouncer announcer, Map<String, String> headers) {
        TemplateContext props = this.context.props();
        announcer.getHeaders().forEach((k, v) -> {
            String value = Templates.resolveTemplate((String)v, (TemplateContext)props);
            if (StringUtils.isNotBlank((String)value)) {
                headers.put((String)k, value);
            }
        });
    }

    private void fireAnnouncerEvent(ExecutionEvent event, org.jreleaser.model.internal.announce.HttpAnnouncer http) {
        try {
            this.context.fireAnnounceStepEvent(event, (org.jreleaser.model.api.announce.Announcer)http.asImmutable());
        }
        catch (WorkflowListenerException e) {
            this.context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
            this.context.getLogger().trace((Throwable)e);
        }
    }
}

