/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.api.release.GithubReleaser;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.release.BaseReleaser;

public final class GithubReleaser
extends BaseReleaser<org.jreleaser.model.api.release.GithubReleaser, GithubReleaser> {
    private static final long serialVersionUID = -7946819245345601709L;
    private final ReleaseNotes releaseNotes = new ReleaseNotes();
    private Boolean draft;
    private String discussionCategoryName;
    @JsonIgnore
    private final org.jreleaser.model.api.release.GithubReleaser immutable = new org.jreleaser.model.api.release.GithubReleaser(){
        private static final long serialVersionUID = -4561765054201402112L;

        public boolean isPrerelease() {
            return GithubReleaser.this.isPrerelease();
        }

        public boolean isDraft() {
            return GithubReleaser.this.isDraft();
        }

        public String getDiscussionCategoryName() {
            return GithubReleaser.this.discussionCategoryName;
        }

        public GithubReleaser.ReleaseNotes getReleaseNotes() {
            return GithubReleaser.this.releaseNotes.asImmutable();
        }

        public String getServiceName() {
            return GithubReleaser.this.getServiceName();
        }

        public boolean isReleaseSupported() {
            return GithubReleaser.this.isReleaseSupported();
        }

        public String getCanonicalRepoName() {
            return GithubReleaser.this.getCanonicalRepoName();
        }

        public String getReverseRepoHost() {
            return GithubReleaser.this.getReverseRepoHost();
        }

        public boolean isMatch() {
            return GithubReleaser.this.isMatch();
        }

        public String getHost() {
            return GithubReleaser.this.getHost();
        }

        public String getName() {
            return GithubReleaser.this.getName();
        }

        public String getRepoUrl() {
            return GithubReleaser.this.getRepoUrl();
        }

        public String getRepoCloneUrl() {
            return GithubReleaser.this.getRepoCloneUrl();
        }

        public String getCommitUrl() {
            return GithubReleaser.this.getCommitUrl();
        }

        public String getSrcUrl() {
            return GithubReleaser.this.getSrcUrl();
        }

        public String getDownloadUrl() {
            return GithubReleaser.this.getDownloadUrl();
        }

        public String getReleaseNotesUrl() {
            return GithubReleaser.this.getReleaseNotesUrl();
        }

        public String getLatestReleaseUrl() {
            return GithubReleaser.this.getLatestReleaseUrl();
        }

        public String getIssueTrackerUrl() {
            return GithubReleaser.this.getIssueTrackerUrl();
        }

        public String getUsername() {
            return GithubReleaser.this.getUsername();
        }

        public String getToken() {
            return GithubReleaser.this.getToken();
        }

        public String getTagName() {
            return GithubReleaser.this.getTagName();
        }

        public String getPreviousTagName() {
            return GithubReleaser.this.getPreviousTagName();
        }

        public String getReleaseName() {
            return GithubReleaser.this.getReleaseName();
        }

        public String getBranch() {
            return GithubReleaser.this.getBranch();
        }

        public String getBranchPush() {
            return GithubReleaser.this.getBranchPush();
        }

        public Releaser.Prerelease getPrerelease() {
            return GithubReleaser.this.getPrerelease().asImmutable();
        }

        public boolean isSign() {
            return GithubReleaser.this.isSign();
        }

        public Changelog getChangelog() {
            return GithubReleaser.this.getChangelog().asImmutable();
        }

        public Releaser.Milestone getMilestone() {
            return GithubReleaser.this.getMilestone().asImmutable();
        }

        public Releaser.Issues getIssues() {
            return GithubReleaser.this.getIssues().asImmutable();
        }

        public boolean isSkipTag() {
            return GithubReleaser.this.isSkipTag();
        }

        public boolean isSkipRelease() {
            return GithubReleaser.this.isSkipRelease();
        }

        public boolean isOverwrite() {
            return GithubReleaser.this.isOverwrite();
        }

        public Releaser.Update getUpdate() {
            return GithubReleaser.this.getUpdate().asImmutable();
        }

        public String getApiEndpoint() {
            return GithubReleaser.this.getApiEndpoint();
        }

        public boolean isArtifacts() {
            return GithubReleaser.this.isArtifacts();
        }

        public boolean isFiles() {
            return GithubReleaser.this.isFiles();
        }

        public boolean isChecksums() {
            return GithubReleaser.this.isChecksums();
        }

        public boolean isCatalogs() {
            return GithubReleaser.this.isCatalogs();
        }

        public boolean isSignatures() {
            return GithubReleaser.this.isSignatures();
        }

        public Active getUploadAssets() {
            return GithubReleaser.this.getUploadAssets();
        }

        public CommitAuthor getCommitAuthor() {
            return GithubReleaser.this.getCommitAuthor().asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GithubReleaser.this.asMap(full));
        }

        public boolean isEnabled() {
            return GithubReleaser.this.isEnabled();
        }

        public String getOwner() {
            return GithubReleaser.this.getOwner();
        }

        public Integer getConnectTimeout() {
            return GithubReleaser.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return GithubReleaser.this.getReadTimeout();
        }
    };

    public GithubReleaser() {
        super("github", true);
        this.setHost("github.com");
        this.setApiEndpoint("https://api.github.com");
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/blob/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    @Override
    public org.jreleaser.model.api.release.GithubReleaser asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GithubReleaser source) {
        super.merge(source);
        this.draft = this.merge(this.draft, source.draft);
        this.discussionCategoryName = this.merge(this.discussionCategoryName, source.discussionCategoryName);
        this.setReleaseNotes(source.releaseNotes);
    }

    public boolean isDraft() {
        return null != this.draft && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return null != this.draft;
    }

    public String getDiscussionCategoryName() {
        return this.discussionCategoryName;
    }

    public void setDiscussionCategoryName(String discussionCategoryName) {
        this.discussionCategoryName = discussionCategoryName;
    }

    public ReleaseNotes getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(ReleaseNotes releaseNotes) {
        this.releaseNotes.merge(releaseNotes);
    }

    @Override
    public String getReverseRepoHost() {
        return "com.github";
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        map.put("discussionCategoryName", this.discussionCategoryName);
        map.put("releaseNotes", this.releaseNotes.asMap(full));
        return map;
    }

    public static final class ReleaseNotes
    extends AbstractModelObject<ReleaseNotes>
    implements Domain,
    EnabledAware {
        private static final long serialVersionUID = -1029998017479730113L;
        private Boolean enabled;
        private String configurationFile;
        @JsonIgnore
        private final GithubReleaser.ReleaseNotes immutable = new GithubReleaser.ReleaseNotes(){
            private static final long serialVersionUID = -301461478911447433L;

            public String getConfigurationFile() {
                return configurationFile;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public GithubReleaser.ReleaseNotes asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(ReleaseNotes source) {
            this.enabled = this.merge(this.enabled, source.enabled);
            this.configurationFile = this.merge(this.configurationFile, source.configurationFile);
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        public String getConfigurationFile() {
            return this.configurationFile;
        }

        public void setConfigurationFile(String configurationFile) {
            this.configurationFile = configurationFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("configurationFile", this.configurationFile);
            return map;
        }
    }
}

