/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.nexus2;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.nexus2.Nexus2;
import org.jreleaser.sdk.nexus2.Nexus2Exception;
import org.jreleaser.sdk.nexus2.api.NexusAPIException;
import org.jreleaser.sdk.nexus2.api.StagingProfile;
import org.jreleaser.sdk.nexus2.api.StagingProfileRepository;
import org.jreleaser.util.StringUtils;

public class Nexus2MavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer, org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer deployer;

    public Nexus2MavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "nexus2";
    }

    public void deploy(String name) throws DeployException {
        Nexus2MavenDeployer.Stage startStage = this.deployer.getStartStage();
        Nexus2MavenDeployer.Stage endStage = this.deployer.getEndStage();
        Nexus2MavenDeployer.StageOperation op = Nexus2MavenDeployer.StageOperation.of((Nexus2MavenDeployer.Stage)startStage, (Nexus2MavenDeployer.Stage)endStage);
        String stagingProfileId = this.deployer.getStagingProfileId();
        String stagingRepositoryId = this.deployer.getStagingRepositoryId();
        if (null != startStage) {
            this.context.getLogger().debug(RB.$((String)"set.to", (Object[])new Object[]{"start.stage", startStage}));
        }
        if (null != endStage) {
            this.context.getLogger().debug(RB.$((String)"set.to", (Object[])new Object[]{"end.stage", endStage}));
        }
        if (null != op) {
            this.context.getLogger().info(RB.$((String)"set.to", (Object[])new Object[]{"nexus2", op}));
        }
        if (StringUtils.isNotBlank((String)stagingProfileId)) {
            this.context.getLogger().debug(RB.$((String)"set.to", (Object[])new Object[]{"stagingProfileId", stagingProfileId}));
        }
        if (StringUtils.isNotBlank((String)stagingRepositoryId)) {
            this.context.getLogger().debug(RB.$((String)"set.to", (Object[])new Object[]{"stagingRepositoryId", stagingRepositoryId}));
        }
        Set deployables = Collections.emptySet();
        if ((op == Nexus2MavenDeployer.StageOperation.FULL_DEPLOYMENT || op == Nexus2MavenDeployer.StageOperation.UPLOAD || op == Nexus2MavenDeployer.StageOperation.UPLOAD_AND_CLOSE) && (deployables = this.collectDeployables()).isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
            return;
        }
        boolean isSnapshot = this.context.getModel().getProject().isSnapshot();
        String baseUrl = this.deployer.getResolvedUrl(this.context.fullProps());
        if (isSnapshot) {
            baseUrl = this.deployer.getResolvedSnapshotUrl(this.context.fullProps());
        }
        String username = this.deployer.getUsername();
        String password = this.deployer.getPassword();
        String groupId = this.context.getModel().getProject().getJava().getGroupId();
        Nexus2 nexus = new Nexus2(this.context.asImmutable(), baseUrl, username, password, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout(), this.context.isDryrun(), this.deployer.getTransitionDelay(), this.deployer.getTransitionMaxRetries());
        if (!isSnapshot) {
            if (op == Nexus2MavenDeployer.StageOperation.FULL_DEPLOYMENT || op == Nexus2MavenDeployer.StageOperation.UPLOAD || op == Nexus2MavenDeployer.StageOperation.UPLOAD_AND_CLOSE) {
                if (StringUtils.isBlank((String)stagingProfileId)) {
                    stagingProfileId = this.findStagingProfileId(nexus, groupId);
                }
                if (StringUtils.isBlank((String)stagingRepositoryId) && !this.context.isDryrun()) {
                    stagingRepositoryId = this.createStagingRepository(nexus, groupId, stagingProfileId);
                }
            } else {
                if (StringUtils.isBlank((String)stagingProfileId)) {
                    stagingProfileId = this.findStagingProfileId(nexus, groupId);
                }
                if (StringUtils.isBlank((String)stagingProfileId) && !this.context.isDryrun()) {
                    throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}));
                }
                if (StringUtils.isBlank((String)stagingRepositoryId)) {
                    List<StagingProfileRepository> repositories = this.findStagingRepositories(nexus, groupId, stagingProfileId);
                    if (op == Nexus2MavenDeployer.StageOperation.RELEASE) {
                        stagingRepositoryId = repositories.stream().filter(r -> r.getState() == StagingProfileRepository.State.CLOSED).map(StagingProfileRepository::getRepositoryId).findFirst().orElse(null);
                    }
                    if (StringUtils.isBlank((String)stagingRepositoryId)) {
                        stagingRepositoryId = repositories.stream().filter(r -> r.getState() == StagingProfileRepository.State.OPEN).map(StagingProfileRepository::getRepositoryId).findFirst().orElse(null);
                    }
                }
                if (StringUtils.isBlank((String)stagingRepositoryId) && !this.context.isDryrun()) {
                    throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_repository", (Object[])new Object[]{groupId}));
                }
            }
        }
        if (op == Nexus2MavenDeployer.StageOperation.FULL_DEPLOYMENT || op == Nexus2MavenDeployer.StageOperation.UPLOAD || op == Nexus2MavenDeployer.StageOperation.UPLOAD_AND_CLOSE) {
            this.uploadArtifacts(nexus, deployables, stagingRepositoryId);
            if (Nexus2MavenDeployer.Stage.UPLOAD == endStage) {
                return;
            }
        }
        if (op == Nexus2MavenDeployer.StageOperation.FULL_DEPLOYMENT || op == Nexus2MavenDeployer.StageOperation.CLOSE || op == Nexus2MavenDeployer.StageOperation.UPLOAD_AND_CLOSE || op == Nexus2MavenDeployer.StageOperation.CLOSE_AND_RELEASE) {
            this.closeRepository(nexus, isSnapshot, groupId, stagingProfileId, stagingRepositoryId);
            if (Nexus2MavenDeployer.Stage.CLOSE == endStage) {
                return;
            }
        }
        if (op == Nexus2MavenDeployer.StageOperation.RELEASE) {
            try {
                this.closeRepository(nexus, isSnapshot, groupId, stagingProfileId, stagingRepositoryId);
            }
            catch (DeployException deployException) {
                // empty catch block
            }
        }
        this.releaseRepository(nexus, isSnapshot, groupId, stagingProfileId, stagingRepositoryId);
    }

    private String findStagingProfileId(Nexus2 nexus, String groupId) throws DeployException {
        try {
            this.context.getLogger().info(RB.$((String)"nexus.lookup.staging.profile", (Object[])new Object[]{groupId}));
            Optional stagingProfile = nexus.findStagingProfiles(groupId).stream().findFirst();
            if (stagingProfile.isPresent()) {
                String stagingProfileId = ((StagingProfile)stagingProfile.get()).getId();
                this.context.getAdditionalProperties().put(this.prefix("stagingProfileId"), stagingProfileId);
                return stagingProfileId;
            }
            if (!this.context.isDryrun()) {
                throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}));
            }
            this.context.getLogger().warn(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}));
        }
        catch (Nexus2Exception e) {
            if (e.getCause() instanceof NexusAPIException) {
                NexusAPIException ne = (NexusAPIException)e.getCause();
                if (this.context.isDryrun()) {
                    if (ne.isUnauthorized() || ne.isForbidden()) {
                        this.context.getLogger().warn(RB.$((String)"ERROR_nexus_forbidden", (Object[])new Object[0]));
                    } else {
                        this.context.getLogger().warn(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}), (Throwable)e);
                    }
                } else if (ne.isUnauthorized() || ne.isForbidden()) {
                    throw new DeployException(RB.$((String)"ERROR_nexus_forbidden", (Object[])new Object[0]), (Throwable)ne);
                }
                if (!this.context.isDryrun()) {
                    throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}), (Throwable)e);
                }
            }
            if (this.context.isDryrun()) {
                this.context.getLogger().warn(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}));
            }
            throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_profile", (Object[])new Object[]{groupId}), (Throwable)e);
        }
        return null;
    }

    private String createStagingRepository(Nexus2 nexus, String groupId, String stagingProfileId) throws DeployException {
        String stagingRepositoryId;
        try {
            this.context.getLogger().info(RB.$((String)"nexus.create.staging.repository", (Object[])new Object[]{groupId}));
            stagingRepositoryId = nexus.createStagingRepository(stagingProfileId, groupId);
            this.context.getAdditionalProperties().put(this.prefix("stagingRepositoryId"), stagingRepositoryId);
        }
        catch (Nexus2Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw new DeployException(RB.$((String)"ERROR_nexus_create_staging_repository", (Object[])new Object[]{groupId}), (Throwable)e);
        }
        return stagingRepositoryId;
    }

    private List<StagingProfileRepository> findStagingRepositories(Nexus2 nexus, String groupId, String stagingProfileId) throws DeployException {
        try {
            this.context.getLogger().info(RB.$((String)"nexus.lookup.staging.repositories", (Object[])new Object[]{groupId}));
            return nexus.findStagingProfileRepositories(stagingProfileId, groupId);
        }
        catch (Nexus2Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw new DeployException(RB.$((String)"ERROR_nexus_find_staging_repositories", (Object[])new Object[]{groupId}), (Throwable)e);
        }
    }

    private void uploadArtifacts(Nexus2 nexus, Set<Deployable> deployables, String stagingRepositoryId) throws DeployException {
        for (Deployable deployable : deployables) {
            this.context.getLogger().info(" - {}", new Object[]{deployable.getFullDeployPath()});
            if (this.context.isDryrun()) continue;
            try {
                nexus.deploy(stagingRepositoryId, deployable.getDeployPath(), deployable.getLocalPath());
            }
            catch (Nexus2Exception e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{this.context.getBasedir().relativize(deployable.getLocalPath()), e.getMessage()}), (Throwable)e);
            }
        }
    }

    private void closeRepository(Nexus2 nexus, boolean isSnapshot, String groupId, String stagingProfileId, String stagingRepositoryId) throws DeployException {
        if (!isSnapshot && !this.context.isDryrun() && this.deployer.isCloseRepository()) {
            try {
                this.context.getLogger().info(RB.$((String)"nexus.close.repository", (Object[])new Object[]{stagingRepositoryId}));
                this.context.getLogger().info(RB.$((String)"nexus.wait.operation", (Object[])new Object[0]));
                nexus.closeStagingRepository(stagingProfileId, stagingRepositoryId, groupId);
            }
            catch (Nexus2Exception e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_nexus_close_repository", (Object[])new Object[]{stagingRepositoryId}), (Throwable)e);
            }
        }
    }

    private void releaseRepository(Nexus2 nexus, boolean isSnapshot, String groupId, String stagingProfileId, String stagingRepositoryId) throws DeployException {
        if (!isSnapshot && !this.context.isDryrun() && this.deployer.isReleaseRepository()) {
            try {
                this.context.getLogger().info(RB.$((String)"nexus.release.repository", (Object[])new Object[]{stagingRepositoryId}));
                this.context.getLogger().info(RB.$((String)"nexus.wait.operation", (Object[])new Object[0]));
                nexus.releaseStagingRepository(stagingProfileId, stagingRepositoryId, groupId);
            }
            catch (Nexus2Exception e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_nexus_release_repository", (Object[])new Object[]{stagingRepositoryId}), (Throwable)e);
            }
        }
    }

    private String prefix(String input) {
        return "deploy" + StringUtils.capitalize((String)this.getDeployer().getType()) + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.getDeployer().getName()) + StringUtils.capitalize((String)input);
    }
}

