/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import feign.form.FormData;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.internal.deploy.maven.Maven;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.model.spi.deploy.maven.MavenDeployer;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.signing.SigningUtils;
import org.jreleaser.sdk.tool.PomChecker;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractMavenDeployer<A extends org.jreleaser.model.api.deploy.maven.MavenDeployer, D extends org.jreleaser.model.internal.deploy.maven.MavenDeployer<A>>
implements MavenDeployer<A, D> {
    private static final Algorithm[] ALGORITHMS = new Algorithm[]{Algorithm.MD5, Algorithm.SHA_1, Algorithm.SHA_256, Algorithm.SHA_512};
    private static final String BUILD_TAG = "-build";
    private static final Map<String, String> KEY_SERVERS = CollectionUtils.map().e((Object)"https://keys.openpgp.org", (Object)"https://keys.openpgp.org/search?q=%s").e((Object)"https://keyserver.ubuntu.com", (Object)"https://keyserver.ubuntu.com/pks/lookup?search=%s&fingerprint=on&options=mr&op=index").e((Object)"https://pgp.mit.edu", (Object)"https://pgp.mit.edu/pks/lookup?op=get&search=0x%s");
    protected final org.jreleaser.model.internal.JReleaserContext context;

    protected AbstractMavenDeployer(org.jreleaser.model.internal.JReleaserContext context) {
        this.context = context;
    }

    protected Set<Deployable> collectDeployables() {
        TreeSet<Deployable> deployables = new TreeSet<Deployable>();
        for (String stagingRepository : this.getDeployer().getStagingRepositories()) {
            this.collectDeployables(deployables, stagingRepository);
        }
        Map<String, Deployable> deployablesMap = deployables.stream().collect(Collectors.toMap(Deployable::getFullDeployPath, Function.identity()));
        Errors errors = this.checkMavenCentralRules(deployablesMap);
        if (errors.hasErrors()) {
            errors.logErrors(this.context.getLogger());
            throw new JReleaserException(RB.$((String)"ERROR_deployer_maven_central_rules", (Object[])new Object[0]));
        }
        this.signDeployables(deployablesMap, deployables);
        this.checksumDeployables(deployablesMap, deployables);
        return deployables;
    }

    public Set<Deployable> collectDeployables(Set<Deployable> deployables, String stagingRepository) {
        Path root = this.context.getBasedir().resolve(stagingRepository).normalize();
        if (!Files.exists(root, new LinkOption[0])) {
            throw new JReleaserException(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"maven." + this.getDeployer().getType() + "." + this.getDeployer().getName() + ".stagingRepository", this.context.relativizeToBasedir(root).toString()}));
        }
        if (!root.toFile().isDirectory()) {
            throw new JReleaserException(RB.$((String)"validation_is_not_a_directory", (Object[])new Object[]{"maven." + this.getDeployer().getType() + "." + this.getDeployer().getName() + ".stagingRepository", this.context.relativizeToBasedir(root).toString()}));
        }
        try {
            DeployableCollector collector = new DeployableCollector(root, this.context.getModel().getProject().isSnapshot());
            Files.walkFileTree(root, collector);
            if (collector.failed) {
                throw new JReleaserException(RB.$((String)"ERROR_deployer_stage_resolution", (Object[])new Object[0]));
            }
            deployables.addAll(collector.deployables);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_deployer_unexpected_error_stage", (Object[])new Object[0]), (Throwable)e);
        }
        return deployables;
    }

    private Errors checkMavenCentralRules(Map<String, Deployable> deployablesMap) {
        Errors errors = new Errors();
        this.context.getLogger().info(RB.$((String)"deployers.maven.prerequesites", (Object[])new Object[0]));
        LinkedHashMap<String, Deployable> buildPoms = new LinkedHashMap<String, Deployable>();
        for (Deployable deployable : deployablesMap.values()) {
            Deployable derived;
            Deployable baseDeployable;
            if (!deployable.getFilename().endsWith(".pom")) continue;
            String base = deployable.getFilename();
            base = base.substring(0, base.length() - 4);
            boolean buildPom = false;
            if (base.endsWith(BUILD_TAG) && deployablesMap.containsKey((baseDeployable = deployable.deriveByFilename(base.substring(0, base.length() - BUILD_TAG.length()) + ".pom")).getFullDeployPath())) {
                buildPom = true;
                buildPoms.put(deployable.getFullDeployPath(), deployable);
            }
            if (buildPom) continue;
            if (deployable.requiresJar() && !deployablesMap.containsKey((derived = deployable.deriveByFilename("jar", base + ".jar")).getFullDeployPath())) {
                errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{derived.getFilename()}));
            }
            if (this.requiresSourcesJar(deployable) && !deployablesMap.containsKey((derived = deployable.deriveByFilename("jar", base + "-sources.jar")).getFullDeployPath())) {
                errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{derived.getFilename()}));
            }
            if (!this.requiresJavadocJar(deployable) || deployablesMap.containsKey((derived = deployable.deriveByFilename("jar", base + "-javadoc.jar")).getFullDeployPath())) continue;
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{derived.getFilename()}));
        }
        if (!this.getDeployer().isVerifyPom()) {
            return errors;
        }
        this.context.getLogger().info(RB.$((String)"deployers.maven.verify.poms", (Object[])new Object[0]));
        Maven.Pomchecker pomcheckerModel = this.context.getModel().getDeploy().getMaven().getPomchecker();
        PomChecker pomChecker = new PomChecker(this.context.asImmutable(), pomcheckerModel.getVersion());
        try {
            if (!pomChecker.setup()) {
                this.context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"pomchecker"}));
                return errors;
            }
        }
        catch (ToolException e) {
            this.context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"pomchecker"}), (Throwable)e);
            return errors;
        }
        for (Deployable deployable : deployablesMap.values()) {
            if (!deployable.getFilename().endsWith(".pom") || buildPoms.containsKey(deployable.getFullDeployPath()) || !this.requiresPomVerification(deployable)) continue;
            ArrayList<String> args = new ArrayList<String>();
            args.add("check-maven-central");
            args.add("--quiet");
            if (this.context.getModel().getProject().isSnapshot() && this.getDeployer().isSnapshotSupported()) {
                args.add("--no-release");
            }
            if (pomChecker.isVersionCompatibleWith("1.9.0")) {
                if (!pomcheckerModel.isFailOnWarning()) {
                    args.add("--no-fail-on-warning");
                }
                if (!pomcheckerModel.isFailOnError()) {
                    args.add("--no-fail-on-error");
                }
            }
            args.add("--file");
            args.add(deployable.getLocalPath().toAbsolutePath().toString());
            this.context.getLogger().debug(RB.$((String)"deployers.maven.verify.pom", (Object[])new Object[]{deployable.getLocalPath()}));
            Command.Result result = Command.Result.empty();
            try {
                result = pomChecker.check(this.context.getBasedir(), args);
            }
            catch (CommandException e) {
                this.handlePomcheckerResult(deployable.getLocalPath().getFileName().toString(), result, e, errors);
            }
            if (result.getExitValue() == 0) continue;
            this.handlePomcheckerResult(deployable.getLocalPath().getFileName().toString(), result, null, errors);
        }
        return errors;
    }

    private void handlePomcheckerResult(String filename, Command.Result result, CommandException e, Errors errors) {
        String plumbing = result.getErr();
        String validation = result.getOut();
        if (StringUtils.isNotBlank((String)validation)) {
            errors.configuration(RB.$((String)"ERROR_deployer_pomchecker_header", (Object[])new Object[]{filename, validation}));
        } else if (StringUtils.isNotBlank((String)plumbing)) {
            errors.configuration(RB.$((String)"ERROR_deployer_pomchecker_header", (Object[])new Object[]{filename, plumbing}));
        } else if (null != e) {
            errors.configuration(e.getMessage());
        }
    }

    private boolean requiresSourcesJar(Deployable deployable) {
        if (!deployable.requiresSourcesJar()) {
            return false;
        }
        Optional<MavenDeployer.ArtifactOverride> override = this.getDeployer().getArtifactOverrides().stream().filter(a -> a.getGroupId().equals(deployable.getGroupId()) && a.getArtifactId().equals(deployable.getArtifactId())).findFirst();
        if (override.isPresent() && override.get().isSourceJarSet()) {
            return override.get().isSourceJar();
        }
        return this.getDeployer().isSourceJar();
    }

    private boolean requiresJavadocJar(Deployable deployable) {
        if (!deployable.requiresJavadocJar()) {
            return false;
        }
        Optional<MavenDeployer.ArtifactOverride> override = this.getDeployer().getArtifactOverrides().stream().filter(a -> a.getGroupId().equals(deployable.getGroupId()) && a.getArtifactId().equals(deployable.getArtifactId())).findFirst();
        if (override.isPresent() && override.get().isJavadocJarSet()) {
            return override.get().isJavadocJar();
        }
        return this.getDeployer().isJavadocJar();
    }

    private boolean requiresPomVerification(Deployable deployable) {
        Optional<MavenDeployer.ArtifactOverride> override = this.getDeployer().getArtifactOverrides().stream().filter(a -> a.getGroupId().equals(deployable.getGroupId()) && a.getArtifactId().equals(deployable.getArtifactId())).findFirst();
        if (override.isPresent() && override.get().isVerifyPomSet()) {
            return override.get().isVerifyPom();
        }
        return this.getDeployer().isVerifyPom();
    }

    private void signDeployables(Map<String, Deployable> deployablesMap, Set<Deployable> deployables) {
        if (!this.getDeployer().isSign()) {
            return;
        }
        this.verifyKeyIsPublished();
        for (Deployable deployable : deployablesMap.values()) {
            Deployable signedDeployable;
            if (deployable.isSignature() || deployable.isChecksum() || deployable.isMavenMetadata() || this.isNewer(signedDeployable = deployable.deriveByFilename(deployable.getFilename() + ".asc"), deployable)) continue;
            try {
                this.context.getLogger().setPrefix("sign");
                SigningUtils.sign((JReleaserContext)this.context.asImmutable(), (Path)deployable.getLocalPath());
                deployables.add(signedDeployable);
            }
            catch (SigningException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_signing_file", (Object[])new Object[]{deployable.getFilename()}), (Throwable)e);
            }
            finally {
                this.context.getLogger().restorePrefix();
            }
        }
    }

    private boolean isNewer(Deployable source, Deployable target) {
        Path sourcePath = source.getLocalPath();
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            return false;
        }
        Path targetPath = target.getLocalPath();
        FileTime sourceLastModifiedTime = null;
        FileTime targetLastModifiedTime = null;
        try {
            sourceLastModifiedTime = Files.getLastModifiedTime(sourcePath, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_timestamp_file", (Object[])new Object[]{sourcePath.getFileName()}), (Throwable)e);
        }
        try {
            targetLastModifiedTime = Files.getLastModifiedTime(targetPath, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_timestamp_file", (Object[])new Object[]{targetPath.getFileName()}), (Throwable)e);
        }
        return sourceLastModifiedTime.compareTo(targetLastModifiedTime) > 0;
    }

    private void verifyKeyIsPublished() {
        Optional publicKeyID = Optional.empty();
        try {
            publicKeyID = SigningUtils.getPublicKeyID((JReleaserContext)this.context.asImmutable());
        }
        catch (SigningException e) {
            this.context.getLogger().warn(RB.$((String)"ERROR_public_key_not_found", (Object[])new Object[0]));
            return;
        }
        if (!publicKeyID.isPresent()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_public_key_not_found", (Object[])new Object[0]));
            return;
        }
        String keyID = ((String)publicKeyID.get()).toUpperCase(Locale.ENGLISH);
        boolean published = false;
        this.context.getLogger().info(RB.$((String)"signing.check.published.key", (Object[])new Object[]{keyID}));
        for (Map.Entry<String, String> e : KEY_SERVERS.entrySet()) {
            try {
                URL url = new URI(String.format(e.getValue(), keyID)).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(20000);
                connection.setReadTimeout(40000);
                if (connection.getResponseCode() < 400) {
                    this.context.getLogger().debug(" + " + e.getKey());
                    published = true;
                    continue;
                }
                this.context.getLogger().debug(" x " + e.getKey());
            }
            catch (MalformedURLException | URISyntaxException url) {
            }
            catch (IOException ex) {
                this.context.getLogger().debug(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]) + " " + ex.getMessage());
            }
        }
        if (published) {
            this.context.getLogger().info(RB.$((String)"signing.key.published", (Object[])new Object[]{keyID}));
        } else {
            this.context.getLogger().warn(RB.$((String)"signing.key.not.published", (Object[])new Object[]{keyID}));
        }
    }

    private void checksumDeployables(Map<String, Deployable> deployablesMap, Set<Deployable> deployables) {
        if (!this.getDeployer().isChecksums()) {
            return;
        }
        for (Deployable deployable : deployablesMap.values()) {
            if (deployable.isChecksum()) continue;
            if (deployable.getFilename().endsWith(".asc")) {
                for (Algorithm algorithm : ALGORITHMS) {
                    Deployable checksumDeployable = deployable.deriveByFilename(deployable.getFilename() + "." + algorithm.formatted());
                    deployables.remove(checksumDeployable);
                }
                continue;
            }
            try {
                byte[] data = Files.readAllBytes(deployable.getLocalPath());
                for (Algorithm algorithm : ALGORITHMS) {
                    Deployable checksumDeployable = deployable.deriveByFilename(deployable.getFilename() + "." + algorithm.formatted());
                    if (this.isNewer(checksumDeployable, deployable)) continue;
                    this.context.getLogger().debug(RB.$((String)"checksum.calculating", (Object[])new Object[]{algorithm.formatted(), deployable.getFilename()}));
                    String checksum = ChecksumUtils.checksum((Algorithm)algorithm, (byte[])data);
                    Files.write(checksumDeployable.getLocalPath(), checksum.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    deployables.add(checksumDeployable);
                }
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_calculate_checksum", (Object[])new Object[]{deployable.getFilename()}), (Throwable)e);
            }
        }
    }

    protected void deployPackages() throws DeployException {
        Set<Deployable> deployables = this.collectDeployables();
        if (deployables.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        org.jreleaser.model.internal.deploy.maven.MavenDeployer deployer = this.getDeployer();
        String baseUrl = deployer.getResolvedUrl(this.context.fullProps());
        String token = deployer.getPassword();
        this.deleteExistingPackages(baseUrl, token, deployables);
        for (Deployable deployable : deployables) {
            if (deployable.isSignature() || deployable.isChecksum()) continue;
            Path localPath = deployable.getLocalPath();
            this.context.getLogger().info(" - {}", new Object[]{deployable.getFilename()});
            if (this.context.isDryrun()) continue;
            try {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                headers.put("Authorization", "Bearer " + token);
                FormData data = ClientUtils.toFormData(localPath);
                String url = baseUrl + deployable.getFullDeployPath();
                ClientUtils.putFile(this.context.getLogger(), url, deployer.getConnectTimeout(), deployer.getReadTimeout(), data, headers);
            }
            catch (IOException | UploadException e) {
                this.context.getLogger().trace(e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{this.context.getBasedir().relativize(localPath), e.getMessage()}), e);
            }
        }
    }

    protected void deleteExistingPackages(String baseUrl, String token, Set<Deployable> deployables) throws DeployException {
    }

    private class DeployableCollector
    extends SimpleFileVisitor<Path> {
        private final Path root;
        private final Set<Deployable> deployables = new TreeSet<Deployable>();
        private final boolean projectIsSnapshot;
        private boolean failed;

        public DeployableCollector(Path root, boolean projectIsSnapshot) {
            this.root = root;
            this.projectIsSnapshot = projectIsSnapshot;
        }

        private void match(Path path) {
            String filename = path.getFileName().toString();
            if (filename.contains("maven-metadata.xml")) {
                if (this.projectIsSnapshot) {
                    this.addDeployable(path);
                }
            } else {
                this.addDeployable(path);
            }
        }

        private void addDeployable(Path path) {
            String stagingRepository = this.root.toAbsolutePath().toString();
            String stagingPath = path.getParent().toAbsolutePath().toString();
            this.deployables.add(new Deployable(stagingRepository, stagingPath.substring(stagingRepository.length()), this.resolvePackaging(path), path.getFileName().toString()));
        }

        private String resolvePackaging(Path artifactPath) {
            if (artifactPath.getFileName().toString().endsWith(".jar")) {
                return "jar";
            }
            if (!artifactPath.getFileName().toString().endsWith(".pom")) {
                return "";
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document document = factory.newDocumentBuilder().parse(artifactPath.toFile());
                String query = "/project/packaging";
                String packaging = (String)XPathFactory.newInstance().newXPath().compile(query).evaluate(document, XPathConstants.STRING);
                return StringUtils.isNotBlank((String)packaging) ? packaging.trim() : "jar";
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.match(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            this.failed = true;
            AbstractMavenDeployer.this.context.getLogger().trace((Throwable)e);
            AbstractMavenDeployer.this.context.getLogger().error(RB.$((String)"ERROR_artifacts_unexpected_error_path", (Object[])new Object[0]), new Object[]{this.root.toAbsolutePath().relativize(file.toAbsolutePath()), e});
            return FileVisitResult.CONTINUE;
        }
    }
}

