/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SnapPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.PlatformUtils;

public class SnapPackagerProcessor
extends AbstractRepositoryPackagerProcessor<SnapPackager> {
    public SnapPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
        if (((SnapPackager)this.packager).isRemoteBuild()) {
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createSnap(props);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        if (((SnapPackager)this.packager).isRemoteBuild()) {
            super.doPublishDistribution(distribution, props);
            return;
        }
        if (this.context.isDryrun()) {
            this.context.getLogger().error(RB.$((String)"dryrun.set", (Object[])new Object[0]));
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.login(distribution);
        this.push(props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.set("distributionJavaMainClass", (Object)distribution.getJava().getMainClass());
        props.set("distributionJavaMainModule", (Object)distribution.getJava().getMainModule());
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        String desc = this.context.getModel().getProject().getLongDescription();
        desc = Arrays.stream(desc.split(System.lineSeparator())).map(line -> "  " + line).collect(Collectors.joining(System.lineSeparator()));
        props.set("projectLongDescription", (Object)MustacheUtils.passThrough((String)("|" + System.lineSeparator() + desc)));
        props.set("snapRepoUrl", (Object)releaser.getResolvedRepoUrl(this.context.getModel(), ((SnapPackager)this.packager).getRepository().getOwner(), ((SnapPackager)this.packager).getRepository().getResolvedName()));
        props.set("snapRepoCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((SnapPackager)this.packager).getRepository().getOwner(), ((SnapPackager)this.packager).getRepository().getResolvedName()));
        props.set("snapRepositoryUrl", (Object)releaser.getResolvedRepoUrl(this.context.getModel(), ((SnapPackager)this.packager).getRepository().getOwner(), ((SnapPackager)this.packager).getRepository().getResolvedName()));
        props.set("snapRepositoryCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((SnapPackager)this.packager).getRepository().getOwner(), ((SnapPackager)this.packager).getRepository().getResolvedName()));
        props.set("snapPackageName", (Object)((SnapPackager)this.packager).getPackageName());
        props.set("snapBase", (Object)((SnapPackager)this.packager).getBase());
        props.set("snapGrade", (Object)((SnapPackager)this.packager).getGrade());
        props.set("snapConfinement", (Object)((SnapPackager)this.packager).getConfinement());
        props.set("snapHasPlugs", (Object)(!((SnapPackager)this.packager).getPlugs().isEmpty() ? 1 : 0));
        props.set("snapPlugs", (Object)((SnapPackager)this.packager).getPlugs());
        props.set("snapHasSlots", (Object)(!((SnapPackager)this.packager).getSlots().isEmpty() ? 1 : 0));
        props.set("snapSlots", (Object)((SnapPackager)this.packager).getSlots());
        props.set("snapHasLocalPlugs", (Object)(!((SnapPackager)this.packager).getLocalPlugs().isEmpty() ? 1 : 0));
        props.set("snapLocalPlugs", (Object)((SnapPackager)this.packager).getLocalPlugs());
        props.set("snapHasLocalSlots", (Object)(!((SnapPackager)this.packager).getLocalSlots().isEmpty() ? 1 : 0));
        props.set("snapLocalSlots", (Object)((SnapPackager)this.packager).getLocalSlots());
        props.set("hasArchitectures", (Object)(!((SnapPackager)this.packager).getArchitectures().isEmpty() ? 1 : 0));
        props.set("snapArchitectures", (Object)((SnapPackager)this.packager).getArchitectures());
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private void login(Distribution distribution) throws PackagerProcessingException {
        Command cmd = new Command("snapcraft").arg("login").arg("--with").arg(this.context.getBasedir().resolve(distribution.getSnap().getExportedLogin()).toAbsolutePath().toString());
        this.executeCommand(cmd);
    }

    private void push(TemplateContext props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = ((SnapPackager)this.packager).getPackageName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("push").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }

    private void createSnap(TemplateContext props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = ((SnapPackager)this.packager).getPackageName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("snap").arg("--output").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }
}

