/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.hooks;

import java.util.Locale;
import org.jreleaser.model.api.hooks.Hook;
import org.jreleaser.util.StringUtils;

public interface ScriptHook
extends Hook {
    public String getRun();

    public Shell getShell();

    public static enum Shell {
        BASH(".sh", "bash --noprofile --norc -eo pipefail {{script}}"),
        SH(".sh", "sh -e {{script}}"),
        CMD(".cmd", "%ComSpec% /D /E:ON /V:OFF /S /C \"CALL \"{{script}}\"\""),
        PWSH(".ps1", "pwsh -command \". '{{script}}'\""),
        POWERSHELL(".ps1", "powershell -command \". '{{script}}'\"");

        private final String extension;
        private final String expression;

        private Shell(String extension, String expression) {
            this.extension = extension;
            this.expression = expression;
        }

        public String extension() {
            return this.extension;
        }

        public String expression() {
            return this.expression;
        }

        public static Shell of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Shell.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

