/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.assemble.Assemble;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.DebAssembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.assemble.ArchiveAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.DebAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.JavaArchiveAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.JlinkAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.JpackageAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.NativeImageAssemblerValidator;
import org.jreleaser.model.internal.validation.catalog.swid.SwidTagValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class AssemblersValidator {
    private AssemblersValidator() {
    }

    public static void validateAssemblers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        List types2;
        Assemble assemble = context.getModel().getAssemble();
        context.getLogger().debug("assemble");
        ArchiveAssemblerValidator.validateArchive(context, mode, errors);
        JavaArchiveAssemblerValidator.validateJavaArchive(context, mode, errors);
        JlinkAssemblerValidator.validateJlink(context, mode, errors);
        JpackageAssemblerValidator.validateJpackage(context, mode, errors);
        NativeImageAssemblerValidator.validateNativeImage(context, mode, errors);
        DebAssemblerValidator.validateDeb(context, mode, errors);
        if (!mode.validateConfig() && !mode.validateAssembly()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<String, List> byDistributionName = new LinkedHashMap<String, List>();
        for (ArchiveAssembler archiveAssembler : assemble.getActiveArchives()) {
            List types22 = byDistributionName.computeIfAbsent(archiveAssembler.getName(), k -> new ArrayList());
            types22.add(archiveAssembler.getType());
        }
        for (DebAssembler debAssembler : assemble.getActiveDebs()) {
            types2 = byDistributionName.computeIfAbsent(debAssembler.getName(), k -> new ArrayList());
            types2.add(debAssembler.getType());
        }
        for (JavaArchiveAssembler javaArchiveAssembler : assemble.getActiveJavaArchives()) {
            types2 = byDistributionName.computeIfAbsent(javaArchiveAssembler.getName(), k -> new ArrayList());
            types2.add(javaArchiveAssembler.getType());
        }
        for (JlinkAssembler jlinkAssembler : assemble.getActiveJlinks()) {
            types2 = byDistributionName.computeIfAbsent(jlinkAssembler.getName(), k -> new ArrayList());
            if (!jlinkAssembler.isExported()) continue;
            types2.add(jlinkAssembler.getType());
        }
        for (JpackageAssembler jpackageAssembler : assemble.getActiveJpackages()) {
            types2 = byDistributionName.computeIfAbsent(jpackageAssembler.getName(), k -> new ArrayList());
            if (!jpackageAssembler.isExported()) continue;
            types2.add(jpackageAssembler.getType());
        }
        for (NativeImageAssembler nativeImageAssembler : assemble.getActiveNativeImages()) {
            types2 = byDistributionName.computeIfAbsent(nativeImageAssembler.getName(), k -> new ArrayList());
            if (!nativeImageAssembler.isExported()) continue;
            types2.add(nativeImageAssembler.getType());
        }
        byDistributionName.forEach((name, types) -> {
            if (types.size() > 1) {
                errors.configuration(RB.$((String)"validation_multiple_assemblers", (Object[])new Object[]{"distribution." + name, types}));
                context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
                assemble.disable();
            }
        });
        boolean activeSet = assemble.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)assemble, "assemble", "ALWAYS");
        assemble.resolveEnabled(context.getModel().getProject());
        if (assemble.isEnabled()) {
            boolean bl;
            boolean bl2 = bl = !assemble.getActiveArchives().isEmpty() || !assemble.getActiveDebs().isEmpty() || !assemble.getActiveJavaArchives().isEmpty() || !assemble.getActiveJlinks().isEmpty() || !assemble.getActiveJpackages().isEmpty() || !assemble.getActiveNativeImages().isEmpty();
            if (!activeSet && !bl) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                assemble.disable();
            }
        }
    }

    public static void postValidateAssemblers(JReleaserContext context) {
        context.getLogger().debug("assemble");
        JpackageAssemblerValidator.postValidateJpackage(context);
    }

    public static void validateAssembler(JReleaserContext context, JReleaserContext.Mode mode, Assembler<?> assembler, Errors errors) {
        if (null == assembler.getStereotype()) {
            assembler.setStereotype(context.getModel().getProject().getStereotype());
        }
        for (Artifact artifact : assembler.getArtifacts()) {
            artifact.resolveActiveAndSelected(context);
        }
        Validator.validateGlobs(context, assembler.getFiles(), assembler.getType() + "." + assembler.getName() + ".files", errors);
        int i = 0;
        for (FileSet fileSet : assembler.getFileSets()) {
            Validator.validateFileSet(context, mode, assembler, fileSet, i++, errors);
        }
        if (mode == JReleaserContext.Mode.ASSEMBLE) {
            TemplateValidator.validateTemplate(context, assembler, errors);
        }
        SwidTagValidator.validateSwid(context, assembler.getSwid(), "assemble." + assembler.getType() + "." + assembler.getName(), errors);
    }

    public static boolean validateJavaAssembler(JReleaserContext context, JReleaserContext.Mode mode, JavaAssembler<?> assembler, Errors errors, boolean checkMainJar) {
        AssemblersValidator.validateAssembler(context, mode, assembler, errors);
        if (checkMainJar) {
            if (null == assembler.getMainJar()) {
                errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{assembler.getType() + "." + assembler.getName() + ".mainJar"}));
                return false;
            }
            if (StringUtils.isBlank((String)assembler.getMainJar().getPath())) {
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{assembler.getType() + "." + assembler.getName() + ".mainJar.path"}));
            }
        }
        Validator.validateGlobs(context, assembler.getJars(), assembler.getType() + "." + assembler.getName() + ".jars", errors);
        return true;
    }

    public static boolean validateJava(JReleaserContext context, JavaAssembler<?> assembler, Errors errors) {
        Project project = context.getModel().getProject();
        Java assemblerJava = assembler.getJava();
        Java projectJava = project.getLanguages().getJava();
        if (!assemblerJava.isEnabledSet() && projectJava.isEnabledSet()) {
            assemblerJava.setEnabled(projectJava.isEnabled());
        }
        if (!assemblerJava.isEnabledSet()) {
            assemblerJava.setEnabled(assemblerJava.isSet());
        }
        if (!assemblerJava.isEnabled()) {
            return false;
        }
        if (StringUtils.isBlank((String)assemblerJava.getArtifactId())) {
            assemblerJava.setArtifactId(projectJava.getArtifactId());
        }
        if (StringUtils.isBlank((String)assemblerJava.getGroupId())) {
            assemblerJava.setGroupId(projectJava.getGroupId());
        }
        if (StringUtils.isBlank((String)assemblerJava.getVersion())) {
            assemblerJava.setVersion(projectJava.getVersion());
        }
        if (StringUtils.isBlank((String)assemblerJava.getMainModule())) {
            assemblerJava.setMainModule(projectJava.getMainModule());
        }
        if (StringUtils.isBlank((String)assemblerJava.getMainClass())) {
            assemblerJava.setMainClass(projectJava.getMainClass());
        }
        if (assemblerJava.getOptions().isEmpty()) {
            assemblerJava.setOptions(projectJava.getOptions());
        } else {
            assemblerJava.addOptions(projectJava.getOptions());
        }
        assemblerJava.getJvmOptions().merge(assemblerJava.getOptions());
        assemblerJava.getJvmOptions().merge(projectJava.getJvmOptions());
        assemblerJava.getEnvironmentVariables().merge(projectJava.getEnvironmentVariables());
        return true;
    }
}

