/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitter;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.sdk.webhooks.WebhooksAnnouncer;

public class GitterAnnouncer
implements Announcer<org.jreleaser.model.api.announce.GitterAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.GitterAnnouncer gitter;

    public GitterAnnouncer(JReleaserContext context) {
        this.context = context;
        this.gitter = context.getModel().getAnnounce().getGitter();
    }

    public org.jreleaser.model.api.announce.GitterAnnouncer getAnnouncer() {
        return this.gitter.asImmutable();
    }

    public String getName() {
        return "gitter";
    }

    public boolean isEnabled() {
        return this.gitter.isEnabled();
    }

    public void announce() throws AnnounceException {
        this.context.getLogger().setPrefix("webhook." + this.getName());
        try {
            WebhooksAnnouncer.announce((JReleaserContext)this.context, (WebhookAnnouncer)this.gitter.asWebhookAnnouncer(), (boolean)false);
        }
        catch (AnnounceException x) {
            this.context.getLogger().warn(x.getMessage().trim());
        }
        finally {
            this.context.getLogger().restorePrefix();
        }
    }
}

