/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.YamlLintConfig;
import com.github.sbaudoin.yamllint.rules.CommentRule;
import com.github.sbaudoin.yamllint.rules.LineRule;
import com.github.sbaudoin.yamllint.rules.Rule;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceReader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class Linter {
    private static final String RULE_TOKEN = "rule:";
    public static final String LEVEL_KEY = "level";
    public static final String NONE_LEVEL = "none";
    public static final String INFO_LEVEL = "info";
    public static final String WARNING_LEVEL = "warning";
    public static final String ERROR_LEVEL = "error";
    private static final Map<Object, Object> PROBLEM_LEVELS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Integer, String>(0, "none"), new AbstractMap.SimpleEntry<String, Integer>("none", 0), new AbstractMap.SimpleEntry<Integer, String>(1, "info"), new AbstractMap.SimpleEntry<String, Integer>("info", 1), new AbstractMap.SimpleEntry<Integer, String>(2, "warning"), new AbstractMap.SimpleEntry<String, Integer>("warning", 2), new AbstractMap.SimpleEntry<Integer, String>(3, "error"), new AbstractMap.SimpleEntry<String, Integer>("error", 3)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));

    private Linter() {
    }

    public static List<LintProblem> run(CharSequence buffer, YamlLintConfig conf) {
        return Linter.run(buffer, conf, new Yaml());
    }

    public static List<LintProblem> run(CharSequence buffer, YamlLintConfig conf, Yaml yaml) {
        return Linter.run(buffer, conf, yaml, null);
    }

    public static List<LintProblem> run(InputStream in, YamlLintConfig conf) throws IOException {
        return Linter.run(in, conf, new Yaml());
    }

    public static List<LintProblem> run(Reader in, YamlLintConfig conf) throws IOException {
        return Linter.run(in, conf, new Yaml());
    }

    public static List<LintProblem> run(InputStream in, YamlLintConfig conf, Yaml yaml) throws IOException {
        return Linter.run(in, conf, yaml, null);
    }

    public static List<LintProblem> run(Reader in, YamlLintConfig conf, Yaml yaml) throws IOException {
        return Linter.run(in, conf, yaml, null);
    }

    public static List<LintProblem> run(YamlLintConfig conf, File file) throws IOException {
        return Linter.run(conf, new Yaml(), file);
    }

    public static List<LintProblem> run(YamlLintConfig conf, Yaml yaml, File file) throws IOException {
        Objects.requireNonNull(conf);
        Objects.requireNonNull(file);
        if (conf.isFileIgnored(file.getPath())) {
            return new ArrayList<LintProblem>();
        }
        try (FileInputStream in = new FileInputStream(file);){
            List<LintProblem> list = Linter.run(in, conf, yaml, file);
            return list;
        }
    }

    public static List<LintProblem> run(InputStream in, YamlLintConfig conf, File file) throws IOException {
        return Linter.run(in, conf, new Yaml(), file);
    }

    public static List<LintProblem> run(Reader in, YamlLintConfig conf, File file) throws IOException {
        return Linter.run(in, conf, new Yaml(), file);
    }

    public static List<LintProblem> run(InputStream in, YamlLintConfig conf, Yaml yaml, File file) throws IOException {
        int numCharsRead;
        Objects.requireNonNull(conf);
        Objects.requireNonNull(in);
        UnicodeReader reader = new UnicodeReader(in);
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return Linter.run(buffer, conf, yaml, file);
    }

    public static List<LintProblem> run(Reader in, YamlLintConfig conf, Yaml yaml, File file) throws IOException {
        return Linter.run(IOUtils.toString((Reader)in), conf, yaml, file);
    }

    public static List<LintProblem> run(CharSequence buffer, YamlLintConfig conf, File file) {
        return Linter.run(buffer, conf, new Yaml(), file);
    }

    public static List<LintProblem> run(CharSequence buffer, YamlLintConfig conf, Yaml yaml, File file) {
        Objects.requireNonNull(conf);
        TreeSet<LintProblem> problems = new TreeSet<LintProblem>((p1, p2) -> {
            if (p1.getLine() < p2.getLine()) {
                return -1;
            }
            if (p1.getLine() > p2.getLine()) {
                return 1;
            }
            if (p1.getColumn() < p2.getColumn()) {
                return -1;
            }
            if (p1.getColumn() > p2.getColumn()) {
                return 1;
            }
            if (p1.getRuleId() == null && p2.getRuleId() != null) {
                return -1;
            }
            return p1.getMessage().compareTo(p2.getMessage());
        });
        LintProblem syntaxError = Linter.getSyntaxError(buffer, yaml);
        if (syntaxError != null) {
            problems.add(syntaxError);
        }
        problems.addAll(Linter.getCosmeticProblems(buffer, conf, file).stream().filter(problem -> syntaxError == null || syntaxError.getLine() != problem.getLine() || syntaxError.getColumn() != problem.getColumn()).collect(Collectors.toList()));
        return new ArrayList<LintProblem>(problems);
    }

    public static Object getProblemLevel(Object key) {
        return PROBLEM_LEVELS.get(key);
    }

    public static LintProblem getSyntaxError(CharSequence buffer) {
        return Linter.getSyntaxError(buffer, new Yaml());
    }

    public static LintProblem getSyntaxError(CharSequence buffer, Yaml yaml) {
        try {
            yaml.parse((Reader)new CharSequenceReader(buffer)).forEach(o -> {});
        }
        catch (MarkedYAMLException e) {
            LintProblem problem = new LintProblem(e.getProblemMark().getLine() + 1, e.getProblemMark().getColumn() + 1, "syntax error: " + e.getProblem());
            problem.setLevel(ERROR_LEVEL);
            problem.setExtraDesc(e.getMessage());
            return problem;
        }
        return null;
    }

    public static List<LintProblem> getCosmeticProblems(CharSequence buffer, YamlLintConfig conf, File file) {
        Objects.requireNonNull(conf);
        List<Rule> rules = conf.getEnabledRules(file);
        List<Rule> tokenRules = rules.stream().filter(rule -> rule.getType() == Rule.TYPE.TOKEN).collect(Collectors.toList());
        List commentRules = rules.stream().filter(rule -> rule.getType() == Rule.TYPE.COMMENT).collect(Collectors.toList());
        List lineRules = rules.stream().filter(rule -> rule.getType() == Rule.TYPE.LINE).collect(Collectors.toList());
        HashMap context = new HashMap();
        tokenRules.forEach(rule -> context.put(rule.getId(), new HashMap()));
        ArrayList<LintProblem> cache = new ArrayList<LintProblem>();
        DisableDirective disabled = new DisableDirective(rules);
        DisableLineDirective disabledForLine = new DisableLineDirective(rules);
        DisableLineDirective disabledForNextLine = new DisableLineDirective(rules);
        String sBuffer = buffer.toString();
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        List<Parser.Lined> items = Parser.getTokensOrCommentsOrLines(sBuffer);
        for (Parser.Lined elem : items) {
            Map ruleConf;
            if (elem instanceof Parser.Token) {
                for (Rule rule2 : tokenRules) {
                    ruleConf = (Map)conf.getRuleConf(rule2.getId());
                    Linter.saveProblemsInCache(cache, rule2, ruleConf, ((TokenRule)rule2).check(ruleConf, ((Parser.Token)elem).getCurr(), ((Parser.Token)elem).getPrev(), ((Parser.Token)elem).getNext(), ((Parser.Token)elem).getNextNext(), (Map)context.get(rule2.getId())));
                }
                continue;
            }
            if (elem instanceof Parser.Comment) {
                for (Rule rule2 : commentRules) {
                    ruleConf = (Map)conf.getRuleConf(rule2.getId());
                    Linter.saveProblemsInCache(cache, rule2, ruleConf, ((CommentRule)rule2).check(ruleConf, (Parser.Comment)elem));
                }
                disabled.processComment((Parser.Comment)elem);
                if (((Parser.Comment)elem).isInline()) {
                    disabledForLine.processComment((Parser.Comment)elem);
                    continue;
                }
                disabledForNextLine.processComment((Parser.Comment)elem);
                continue;
            }
            if (!(elem instanceof Parser.Line)) continue;
            for (Rule rule2 : lineRules) {
                ruleConf = (Map)conf.getRuleConf(rule2.getId());
                Linter.saveProblemsInCache(cache, rule2, ruleConf, ((LineRule)rule2).check(ruleConf, (Parser.Line)elem));
            }
            for (LintProblem problem : cache) {
                if (disabledForLine.isDisabledByDirective(problem) || disabled.isDisabledByDirective(problem)) continue;
                problems.add(problem);
            }
            disabledForLine = disabledForNextLine;
            disabledForNextLine = new DisableLineDirective(rules);
            cache.clear();
        }
        return problems;
    }

    private static void saveProblemsInCache(List<LintProblem> cache, Rule rule, Map<?, ?> conf, List<LintProblem> problems) {
        for (LintProblem problem : problems) {
            problem.setRuleId(rule.getId());
            problem.setLevel((String)conf.get(LEVEL_KEY));
            cache.add(problem);
        }
    }

    private static class DisableDirective {
        protected List<String> rules = new ArrayList<String>();
        protected List<String> allRules = new ArrayList<String>();

        DisableDirective(List<Rule> rules) {
            rules.forEach(rule -> this.allRules.add(rule.getId()));
        }

        public void processComment(Parser.Comment token) {
            String comment = token.toString();
            Matcher disableMatcher = Pattern.compile("# yamllint disable(( rule:\\S+)*)\\s*$").matcher(comment);
            Matcher enableMatcher = Pattern.compile("# yamllint enable(( rule:\\S+)*)\\s*$").matcher(comment);
            if (disableMatcher.find()) {
                String[] cRules = disableMatcher.group(1).trim().replace(Linter.RULE_TOKEN, "").split(" ");
                if (cRules.length == 0 || "".equals(cRules[0])) {
                    this.rules = new ArrayList<String>(this.allRules);
                } else {
                    this.rules.addAll(Arrays.stream(cRules).filter(id -> this.allRules.contains(id)).collect(Collectors.toList()));
                }
            } else if (enableMatcher.find()) {
                String[] cRules = enableMatcher.group(1).trim().replace(Linter.RULE_TOKEN, "").split(" ");
                if (cRules.length == 0 || "".equals(cRules[0])) {
                    this.rules.clear();
                } else {
                    for (String id2 : cRules) {
                        this.rules.remove(id2);
                    }
                }
            }
        }

        public boolean isDisabledByDirective(LintProblem problem) {
            return this.rules.contains(problem.getRuleId());
        }
    }

    private static class DisableLineDirective
    extends DisableDirective {
        public DisableLineDirective(List<Rule> rules) {
            super(rules);
        }

        @Override
        public void processComment(Parser.Comment token) {
            String comment = token.toString();
            Matcher disableMatcher = Pattern.compile("# yamllint disable-line(( rule:\\S+)*)\\s*$").matcher(comment);
            if (disableMatcher.find()) {
                String[] cRules = disableMatcher.group(1).trim().replace(Linter.RULE_TOKEN, "").split(" ");
                if (cRules.length == 0 || "".equals(cRules[0])) {
                    this.rules = new ArrayList(this.allRules);
                } else {
                    for (String id : cRules) {
                        if (!this.allRules.contains(id)) continue;
                        this.rules.add(id);
                    }
                }
            }
        }
    }
}

