/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.forgejo;

import feign.form.FormData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.upload.ForgejoUploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.commons.ClientUtils;

public class ForgejoArtifactUploader
extends AbstractArtifactUploader<ForgejoUploader, org.jreleaser.model.internal.upload.ForgejoUploader> {
    private org.jreleaser.model.internal.upload.ForgejoUploader uploader;

    public ForgejoArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.upload.ForgejoUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(org.jreleaser.model.internal.upload.ForgejoUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "forgejo";
    }

    public void upload(String name) throws UploadException {
        Set artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String token = this.uploader.getToken();
        for (Artifact artifact : artifacts) {
            Path path = artifact.getEffectivePath(this.context);
            this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
            if (this.context.isDryrun()) continue;
            try {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                headers.put("Authorization", "token " + token);
                FormData data = ClientUtils.toFormData((Path)path);
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)this.uploader.getResolvedUploadUrl(this.context, artifact), (int)this.uploader.getConnectTimeout(), (int)this.uploader.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
            }
            catch (UploadException e) {
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), e.getCause());
            }
        }
    }
}

