/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.util.LinkedHashMap;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SdkmanPackager;
import org.jreleaser.model.internal.util.SdkmanHelper;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractPackagerProcessor;
import org.jreleaser.sdk.sdkman.MajorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.MinorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.util.StringUtils;

public class SdkmanPackagerProcessor
extends AbstractPackagerProcessor<SdkmanPackager> {
    public SdkmanPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        SdkmanPackager sdkman = distribution.getSdkman();
        LinkedHashMap platforms = new LinkedHashMap();
        SdkmanHelper.collectArtifacts((JReleaserContext)this.context, (Distribution)distribution, platforms);
        try {
            String candidate = StringUtils.isNotBlank((String)sdkman.getCandidate()) ? sdkman.getCandidate().trim() : this.context.getModel().getProject().getName();
            String releaseNotesUrl = Templates.resolveTemplate((String)sdkman.getReleaseNotesUrl(), (TemplateContext)props);
            if (sdkman.getCommand() == Sdkman.Command.MAJOR) {
                this.context.getLogger().info(RB.$((String)"sdkman.publish.major", (Object[])new Object[0]), new Object[]{candidate});
                ((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)MajorReleaseSdkmanCommand.builder((org.jreleaser.model.api.JReleaserContext)this.context.asImmutable()).connectTimeout(sdkman.getConnectTimeout().intValue())).readTimeout(sdkman.getReadTimeout().intValue())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).skipAnnounce(false)).build().execute();
            } else if (sdkman.getCommand() == Sdkman.Command.MINOR) {
                this.context.getLogger().info(RB.$((String)"sdkman.publish.minor", (Object[])new Object[0]), new Object[]{candidate});
                ((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)MinorReleaseSdkmanCommand.builder((org.jreleaser.model.api.JReleaserContext)this.context.asImmutable()).connectTimeout(sdkman.getConnectTimeout().intValue())).readTimeout(sdkman.getReadTimeout().intValue())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).skipAnnounce(false)).build().execute();
            }
            sdkman.setPublished(true);
        }
        catch (SdkmanException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.set("sdkmanCandidate", (Object)((SdkmanPackager)this.packager).getCandidate());
        props.set("sdkmanReleaseNotesUrl", (Object)Templates.resolveTemplate((String)((SdkmanPackager)this.packager).getReleaseNotesUrl(), (TemplateContext)props));
    }
}

