/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.upload;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.upload.ProjectUploader;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.internal.upload.Upload;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.model.spi.upload.UploadException;

public final class Uploaders {
    private Uploaders() {
    }

    public static void upload(JReleaserContext context) {
        context.getLogger().info(RB.$((String)"uploaders.header", (Object[])new Object[0]));
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("upload");
        Upload upload = context.getModel().getUpload();
        if (!upload.isEnabled()) {
            context.getLogger().info(RB.$((String)"uploaders.not.enabled", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        try {
            Uploaders.doUpload(context, upload);
        }
        finally {
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
        }
    }

    private static void doUpload(JReleaserContext context, Upload upload) {
        if (!context.getIncludedUploaderTypes().isEmpty()) {
            for (String uploaderType : context.getIncludedUploaderTypes()) {
                if (!JReleaserSupport.supportedUploaders().contains(uploaderType)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_uploader", (Object[])new Object[]{uploaderType}));
                    continue;
                }
                Map uploaders = upload.findUploadersByType(uploaderType);
                if (uploaders.isEmpty()) {
                    context.getLogger().info(RB.$((String)"uploaders.no.match", (Object[])new Object[0]), new Object[]{uploaderType});
                    return;
                }
                if (!context.getIncludedUploaderNames().isEmpty()) {
                    boolean uploaded = false;
                    for (String uploaderName : context.getIncludedUploaderNames()) {
                        if (!uploaders.containsKey(uploaderName)) {
                            context.getLogger().warn(RB.$((String)"uploaders.uploader.not.configured", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                            continue;
                        }
                        Uploader uploader2 = (Uploader)uploaders.get(uploaderName);
                        if (!uploader2.isEnabled()) {
                            context.getLogger().info(RB.$((String)"uploaders.uploader.disabled", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                            continue;
                        }
                        context.getLogger().info(RB.$((String)"uploaders.upload.with", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                        if (!Uploaders.upload(context, uploader2)) continue;
                        uploaded = true;
                    }
                    if (uploaded) continue;
                    context.getLogger().info(RB.$((String)"uploaders.not.triggered", (Object[])new Object[0]));
                    continue;
                }
                context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts.with", (Object[])new Object[0]), new Object[]{uploaderType});
                boolean[] uploaded = new boolean[]{false};
                uploaders.values().forEach(uploader -> {
                    if (Uploaders.upload(context, uploader)) {
                        uploaded[0] = true;
                    }
                });
                if (uploaded[0]) continue;
                context.getLogger().info(RB.$((String)"uploaders.not.triggered", (Object[])new Object[0]));
            }
        } else if (!context.getIncludedUploaderNames().isEmpty()) {
            boolean[] uploaded = new boolean[]{false};
            for (String uploaderName : context.getIncludedUploaderNames()) {
                List<Uploader> filteredUploaders = upload.findAllActiveUploaders().stream().filter(a -> uploaderName.equals(a.getName())).collect(Collectors.toList());
                if (!filteredUploaders.isEmpty()) {
                    context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts.to", (Object[])new Object[0]), new Object[]{uploaderName});
                    filteredUploaders.forEach(uploader -> {
                        if (Uploaders.upload(context, uploader)) {
                            uploaded[0] = true;
                        }
                    });
                    continue;
                }
                context.getLogger().warn(RB.$((String)"uploaders.uploader.not.configured2", (Object[])new Object[0]), new Object[]{uploaderName});
            }
            if (!uploaded[0]) {
                context.getLogger().info(RB.$((String)"uploaders.not.triggered", (Object[])new Object[0]));
            }
        } else {
            boolean uploaded = false;
            context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts", (Object[])new Object[0]));
            for (Uploader uploader3 : upload.findAllActiveUploaders()) {
                String uploaderType = uploader3.getType();
                String uploaderName = uploader3.getName();
                if (context.getExcludedUploaderTypes().contains(uploaderType) || context.getExcludedUploaderNames().contains(uploaderName)) {
                    context.getLogger().info(RB.$((String)"uploaders.uploader.excluded", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                    continue;
                }
                if (!Uploaders.upload(context, uploader3)) continue;
                uploaded = true;
            }
            if (!uploaded) {
                context.getLogger().info(RB.$((String)"uploaders.not.triggered", (Object[])new Object[0]));
            }
        }
    }

    private static boolean upload(JReleaserContext context, Uploader<?> uploader) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(uploader.getType());
            Uploaders.fireUploadEvent(ExecutionEvent.before((String)JReleaserCommand.UPLOAD.toStep()), context, uploader);
            ProjectUploader projectUploader = Uploaders.createProjectUploader(context, uploader);
            boolean uploaded = projectUploader.upload();
            Uploaders.fireUploadEvent(ExecutionEvent.success((String)JReleaserCommand.UPLOAD.toStep()), context, uploader);
            boolean bl = uploaded;
            return bl;
        }
        catch (UploadException e) {
            Uploaders.fireUploadEvent(ExecutionEvent.failure((String)JReleaserCommand.UPLOAD.toStep(), (Throwable)e), context, uploader);
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static ProjectUploader createProjectUploader(JReleaserContext context, Uploader<?> uploader) {
        return ProjectUploader.builder().context(context).uploader(uploader).build();
    }

    private static void fireUploadEvent(ExecutionEvent event, JReleaserContext context, Uploader<?> uploader) {
        block4: {
            if (!uploader.isEnabled()) {
                return;
            }
            try {
                context.fireUploadStepEvent(event, uploader.asImmutable());
            }
            catch (WorkflowListenerException e) {
                context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                context.getLogger().trace((Throwable)e);
                if (event.getType() == ExecutionEvent.Type.FAILURE || e.getListener().isContinueOnError()) break block4;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e.getCause());
            }
        }
    }
}

