/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.environment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class Environment
extends AbstractModelObject<Environment>
implements Domain {
    private static final long serialVersionUID = 4554098923129885325L;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private final Map<String, Object> sourcedProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private PropertiesSource propertiesSource;
    private String variables;
    @JsonIgnore
    private Properties vars;
    @JsonIgnore
    private Path propertiesFile;
    @JsonIgnore
    private final org.jreleaser.model.api.environment.Environment immutable = new org.jreleaser.model.api.environment.Environment(){
        private static final long serialVersionUID = -7287090119869371299L;

        public Properties getVars() {
            return Environment.this.vars;
        }

        public String getVariables() {
            return Environment.this.variables;
        }

        public Map<String, Object> getProperties() {
            return Collections.unmodifiableMap(Environment.this.properties);
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Environment.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.environment.Environment asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Environment source) {
        this.variables = this.merge(this.variables, source.variables);
        this.setProperties(this.merge(this.properties, source.properties));
        this.setPropertiesSource(this.merge(this.propertiesSource, source.propertiesSource));
    }

    public String resolve(String key) {
        return this.env(key, Env.sys((String)key, (String)""));
    }

    public String resolve(String key, String value) {
        return this.env(key, Env.sys((String)key, (String)value));
    }

    public String resolveOrDefault(String key, String value, String defaultValue) {
        String result = this.env(key, Env.sys((String)key, (String)value));
        return StringUtils.isNotBlank((String)result) ? result : defaultValue;
    }

    private String env(String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        return this.getVariable(Env.envKey((String)key));
    }

    public Properties getVars() {
        return this.vars;
    }

    public String getVariable(String key) {
        return this.vars.getProperty(Env.envKey((String)key));
    }

    public boolean isSet() {
        return StringUtils.isNotBlank((String)this.variables) || !this.properties.isEmpty();
    }

    public PropertiesSource getPropertiesSource() {
        return this.propertiesSource;
    }

    public void setPropertiesSource(PropertiesSource propertiesSource) {
        this.propertiesSource = propertiesSource;
        if (null != this.propertiesSource) {
            this.sourcedProperties.putAll(propertiesSource.getProperties());
        }
    }

    public String getVariables() {
        return this.variables;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public Map<String, Object> getSourcedProperties() {
        return this.sourcedProperties;
    }

    public Path getPropertiesFile() {
        return this.propertiesFile;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("variables", this.variables);
        map.put("properties", this.properties);
        return map;
    }

    public void initProps(JReleaserContext context) {
        if (null == this.vars) {
            Path envFilePath;
            this.vars = new Properties();
            Path configDirectory = null;
            String home = System.getenv("XDG_CONFIG_HOME");
            if (StringUtils.isNotBlank((String)home) && Files.exists(Paths.get(home, new String[0]).resolve("jreleaser"), new LinkOption[0])) {
                configDirectory = Paths.get(home, new String[0]).resolve("jreleaser");
            }
            if (null == configDirectory) {
                home = System.getenv("JRELEASER_USER_HOME");
                if (StringUtils.isBlank((String)home)) {
                    home = System.getProperty("user.home") + File.separator + ".jreleaser";
                }
                configDirectory = Paths.get(home, new String[0]);
            }
            this.loadVariables(context, this.resolveConfigFileAt(configDirectory).orElse(configDirectory.resolve("config.properties")));
            if (StringUtils.isNotBlank((String)this.variables)) {
                this.loadVariables(context, context.getBasedir().resolve(this.variables.trim()));
            }
            if (Files.exists(envFilePath = context.getBasedir().resolve(".env"), new LinkOption[0])) {
                this.loadVariables(context, envFilePath);
            }
            TreeSet<String> keyNames = new TreeSet<String>();
            Properties envVars = new Properties();
            System.getenv().forEach((k, v) -> {
                if (k.startsWith("JRELEASER_") && StringUtils.isNotBlank((String)v)) {
                    keyNames.add((String)k);
                    envVars.put(k, v);
                }
            });
            if (System.getenv().containsKey(Env.envKey((String)"DEFAULT_GIT_REMOTE"))) {
                keyNames.add(Env.envKey((String)"DEFAULT_GIT_REMOTE"));
            }
            if (!keyNames.isEmpty()) {
                context.getLogger().debug(RB.$((String)"environment.variables.env", (Object[])new Object[0]));
                keyNames.forEach(message -> context.getLogger().debug("  " + message));
            }
            keyNames.clear();
            System.getProperties().stringPropertyNames().forEach(k -> {
                if (k.startsWith("jreleaser.")) {
                    keyNames.add((String)k);
                }
            });
            if (!keyNames.isEmpty()) {
                context.getLogger().debug(RB.$((String)"environment.system.properties", (Object[])new Object[0]));
                keyNames.forEach(message -> context.getLogger().debug("  " + message));
            }
            Properties merged = new Properties();
            merged.putAll((Map<?, ?>)envVars);
            merged.putAll((Map<?, ?>)this.vars);
            this.vars.clear();
            this.vars.putAll((Map<?, ?>)merged);
            if (null != this.propertiesSource) {
                this.sourcedProperties.putAll(this.propertiesSource.getProperties());
            }
        }
    }

    private void loadVariables(JReleaserContext context, Path file) {
        this.propertiesFile = file;
        context.getLogger().info(RB.$((String)"environment.load.variables", (Object[])new Object[0]), new Object[]{file.toAbsolutePath()});
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Properties p = new Properties();
                if (file.getFileName().toString().endsWith(".properties") || file.getFileName().toString().equals(".env")) {
                    try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                        p.load(in);
                    }
                } else {
                    p.putAll(JReleaserConfigLoader.loadProperties(file));
                }
                this.vars.putAll((Map<?, ?>)p);
                TreeSet keyNames = new TreeSet();
                p.stringPropertyNames().stream().filter(k -> k.startsWith("JRELEASER_")).forEach(keyNames::add);
                if (!keyNames.isEmpty()) {
                    context.getLogger().debug(RB.$((String)"environment.variables.file", (Object[])new Object[]{file.getFileName().toString()}));
                    keyNames.forEach(message -> context.getLogger().debug("  " + message));
                }
            }
            catch (IOException e) {
                context.getLogger().debug(RB.$((String)"environment.variables.load.error", (Object[])new Object[0]), new Object[]{file.toAbsolutePath(), e});
            }
        } else {
            context.getLogger().warn(RB.$((String)"environment.variables.source.missing", (Object[])new Object[0]), new Object[]{file.toAbsolutePath()});
        }
    }

    private Optional<Path> resolveConfigFileAt(Path directory) {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            Path file = directory.resolve("config." + parser.getPreferredFileExtension());
            if (!Files.exists(file, new LinkOption[0])) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public boolean getBooleanProperty(String key) {
        boolean keyInProperties = this.properties.containsKey(key) && Boolean.parseBoolean(String.valueOf(this.properties.get(key)));
        boolean keyInSourcedProperties = this.sourcedProperties.containsKey(key) && Boolean.parseBoolean(String.valueOf(this.sourcedProperties.get(key)));
        return keyInProperties || keyInSourcedProperties;
    }

    public static interface PropertiesSource
    extends Serializable {
        public Map<String, String> getProperties();
    }

    public static class MapPropertiesSource
    extends AbstractPropertiesSource {
        private static final long serialVersionUID = 6643212572356054605L;
        private final Map<String, ?> properties;

        public MapPropertiesSource(Map<String, ?> properties) {
            this.properties = properties;
        }

        @Override
        protected Map<String, String> doGetProperties() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            this.properties.forEach((k, v) -> map.put((String)k, String.valueOf(v)));
            return map;
        }
    }

    public static class PropertiesPropertiesSource
    extends AbstractPropertiesSource {
        private static final long serialVersionUID = 7747477120107034027L;
        private final Properties properties;

        public PropertiesPropertiesSource(Properties properties) {
            this.properties = properties;
        }

        @Override
        protected Map<String, String> doGetProperties() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(String.valueOf(k), String.valueOf(v))));
            return map;
        }
    }

    public static abstract class AbstractPropertiesSource
    implements PropertiesSource {
        private static final long serialVersionUID = 9102569253517657171L;

        @Override
        public Map<String, String> getProperties() {
            Map<String, String> props = this.doGetProperties();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            props.forEach((key, value) -> {
                if (key.startsWith("JRELEASER_")) {
                    return;
                }
                String k = key.replace(".", "-");
                k = StringUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)k);
                map.put(k, (String)value);
            });
            return map;
        }

        protected abstract Map<String, String> doGetProperties();
    }
}

