/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.SftpDownloader;
import org.jreleaser.model.internal.validation.common.SshValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SftpDownloaderValidator {
    private SftpDownloaderValidator() {
    }

    public static void validateSftpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, SftpDownloader> sftp = context.getModel().getDownload().getSftp();
        if (!sftp.isEmpty()) {
            context.getLogger().debug("download.sftp");
        }
        for (Map.Entry<String, SftpDownloader> e : sftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateDownload()) continue;
            Errors incoming = new Errors();
            SftpDownloaderValidator.validateSftpDownloader(context, e.getValue(), incoming);
            Validator.mergeErrors(context, errors, incoming, e.getValue());
        }
    }

    private static void validateSftpDownloader(JReleaserContext context, SftpDownloader downloader, Errors errors) {
        context.getLogger().debug("download.sftp.{}", new Object[]{downloader.getName()});
        Validator.resolveActivatable(context, (Activatable)downloader, CollectionUtils.listOf((Object[])new String[]{"download.sftp." + downloader.getName(), "download.sftp"}), "ALWAYS");
        if (!downloader.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        SshValidator.validateSsh(context, downloader, downloader.getType(), downloader.getName(), "download.", errors);
        Validator.validateTimeout(downloader);
        if (downloader.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"download.sftp." + downloader.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : downloader.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"download.sftp." + downloader.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

