/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.download;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.downloader.spi.ArtifactDownloader;
import org.jreleaser.model.downloader.spi.ArtifactDownloaderFactory;
import org.jreleaser.util.JReleaserException;

public class ArtifactDownloaders {
    public static <D extends Downloader> ArtifactDownloader<D> findDownloader(JReleaserContext context, D downloader) {
        Map<String, ArtifactDownloader> downloaders = StreamSupport.stream(ServiceLoader.load(ArtifactDownloaderFactory.class, ArtifactDownloaders.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(ArtifactDownloaderFactory::getName, factory -> factory.getArtifactDownloader(context)));
        if (downloaders.containsKey(downloader.getType())) {
            ArtifactDownloader artifactDownloader = downloaders.get(downloader.getType());
            artifactDownloader.setDownloader(downloader);
            return artifactDownloader;
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_downloader", (Object[])new Object[]{downloader.getType()}));
    }
}

