/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.sdk.git.ChangelogGenerator;
import org.jreleaser.util.StringUtils;

public class ChangelogProvider {
    public static String getChangelog(JReleaserContext context) throws IOException {
        Changelog changelog = context.getModel().getRelease().getGitService().getChangelog();
        if (!changelog.isEnabled()) {
            context.getLogger().info(RB.$((String)"changelog.disabled", (Object[])new Object[0]));
            return "";
        }
        return ChangelogProvider.storeChangelog(context, ChangelogProvider.resolveChangelog(context));
    }

    public static String storeChangelog(JReleaserContext context, String content) throws IOException {
        Path changelogFile = context.getOutputDirectory().resolve("release").resolve("CHANGELOG.md");
        context.getLogger().info(RB.$((String)"changelog.generator.generate", (Object[])new Object[0]), new Object[]{context.getBasedir().relativize(changelogFile)});
        context.getLogger().debug(content);
        Files.createDirectories(changelogFile.getParent(), new FileAttribute[0]);
        Files.write(changelogFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        return content;
    }

    private static String resolveChangelog(JReleaserContext context) throws IOException {
        Changelog changelog = context.getModel().getRelease().getGitService().getChangelog();
        String externalChangelog = changelog.getExternal();
        if (StringUtils.isNotBlank((String)externalChangelog)) {
            Path externalChangelogPath = context.getBasedir().resolve(Paths.get(externalChangelog, new String[0]));
            File externalChangelogFile = externalChangelogPath.toFile();
            if (!externalChangelogFile.exists()) {
                throw new IllegalStateException(RB.$((String)"ERROR_changelog_not_exist", (Object[])new Object[]{context.getBasedir().relativize(externalChangelogPath)}));
            }
            context.getLogger().info(RB.$((String)"changelog.generator.read", (Object[])new Object[0]), new Object[]{context.getBasedir().relativize(externalChangelogPath)});
            return new String(Files.readAllBytes(externalChangelogPath));
        }
        return ChangelogGenerator.generate(context);
    }
}

