/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Locale;
import java.util.Objects;
import org.jreleaser.util.StringUtils;

public class ExecutionEvent {
    private final Type type;
    private final String name;

    private ExecutionEvent(Type type, String name) {
        this.type = Objects.requireNonNull(type, "'type' must not be null");
        this.name = StringUtils.requireNonBlank((String)name, (String)"'name' must not be blank");
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static ExecutionEvent before(String name) {
        return new ExecutionEvent(Type.BEFORE, name);
    }

    public static ExecutionEvent success(String name) {
        return new ExecutionEvent(Type.SUCCESS, name);
    }

    public static ExecutionEvent failure(String name) {
        return new ExecutionEvent(Type.FAILURE, name);
    }

    public static enum Type {
        BEFORE,
        SUCCESS,
        FAILURE;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Type of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Type.valueOf(str.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

