/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Snap;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SnapValidator
extends Validator {
    public static void validateSnap(JReleaserContext context, Distribution distribution, Snap packager, Errors errors) {
        context.getLogger().debug("distribution.{}.snap", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        Snap parentPackager = model.getPackagers().getSnap();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        SnapValidator.validateCommitAuthor(packager, parentPackager);
        Snap.SnapTap snap = packager.getSnap();
        snap.resolveEnabled(model.getProject());
        if (StringUtils.isBlank((String)snap.getName())) {
            snap.setName(distribution.getName() + "-snap");
        }
        SnapValidator.validateTap(context, distribution, snap, parentPackager.getSnap(), "snap.snap");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        SnapValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        SnapValidator.mergeSnapPlugs(packager, parentPackager);
        SnapValidator.mergeSnapSlots(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getBase())) {
            packager.setBase(parentPackager.getBase());
            if (StringUtils.isBlank((String)packager.getBase())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.base"}));
            }
        }
        if (StringUtils.isBlank((String)packager.getGrade())) {
            packager.setGrade(parentPackager.getGrade());
            if (StringUtils.isBlank((String)packager.getGrade())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.grade"}));
            }
        }
        if (StringUtils.isBlank((String)packager.getConfinement())) {
            packager.setConfinement(parentPackager.getConfinement());
            if (StringUtils.isBlank((String)packager.getConfinement())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.confinement"}));
            }
        }
        if (!packager.isRemoteBuildSet() && parentPackager.isRemoteBuildSet()) {
            packager.setRemoteBuild(parentPackager.isRemoteBuild());
        }
        if (!packager.isRemoteBuild() && StringUtils.isBlank((String)packager.getExportedLogin())) {
            packager.setExportedLogin(parentPackager.getExportedLogin());
            if (StringUtils.isBlank((String)packager.getExportedLogin())) {
                errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.exportedLogin"}));
            } else if (!Files.exists(context.getBasedir().resolve(packager.getExportedLogin()), new LinkOption[0])) {
                errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.exportedLogin", context.getBasedir().resolve(packager.getExportedLogin())}));
            }
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
        packager.addArchitecture(parentPackager.getArchitectures());
        for (int i = 0; i < packager.getArchitectures().size(); ++i) {
            Snap.Architecture arch = packager.getArchitectures().get(i);
            if (arch.hasBuildOn()) continue;
            errors.configuration(RB.$((String)"validation_snap_missing_buildon", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.architectures", i}));
        }
    }

    private static void mergeSnapPlugs(Snap packager, Snap common) {
        LinkedHashSet<String> localPlugs = new LinkedHashSet<String>();
        localPlugs.addAll(packager.getLocalPlugs());
        localPlugs.addAll(common.getLocalPlugs());
        packager.setLocalPlugs(localPlugs);
        Map<String, Snap.Plug> commonPlugs = common.getPlugs().stream().collect(Collectors.toMap(Snap.Plug::getName, Snap.Plug::copyOf));
        Map<String, Snap.Plug> packagerPlugs = packager.getPlugs().stream().collect(Collectors.toMap(Snap.Plug::getName, Snap.Plug::copyOf));
        commonPlugs.forEach((name, cp) -> {
            Snap.Plug tp = (Snap.Plug)packagerPlugs.remove(name);
            if (null != tp) {
                cp.getAttributes().putAll(tp.getAttributes());
                LinkedHashSet<String> tmp = new LinkedHashSet<String>(cp.getReads());
                tmp.addAll(tp.getReads());
                cp.setReads(new ArrayList<String>(tmp));
                tmp = new LinkedHashSet<String>(cp.getWrites());
                tmp.addAll(tp.getWrites());
                cp.setWrites(new ArrayList<String>(tmp));
            }
        });
        commonPlugs.putAll(packagerPlugs);
        packager.setPlugs(new ArrayList<Snap.Plug>(commonPlugs.values()));
    }

    private static void mergeSnapSlots(Snap packager, Snap common) {
        LinkedHashSet<String> localSlots = new LinkedHashSet<String>();
        localSlots.addAll(packager.getLocalSlots());
        localSlots.addAll(common.getLocalSlots());
        packager.setLocalSlots(localSlots);
        Map<String, Snap.Slot> commonSlots = common.getSlots().stream().collect(Collectors.toMap(Snap.Slot::getName, Snap.Slot::copyOf));
        Map<String, Snap.Slot> packagerSlots = packager.getSlots().stream().collect(Collectors.toMap(Snap.Slot::getName, Snap.Slot::copyOf));
        commonSlots.forEach((name, cp) -> {
            Snap.Slot tp = (Snap.Slot)packagerSlots.remove(name);
            if (null != tp) {
                cp.getAttributes().putAll(tp.getAttributes());
                LinkedHashSet<String> tmp = new LinkedHashSet<String>(cp.getReads());
                tmp.addAll(tp.getReads());
                cp.setReads(new ArrayList<String>(tmp));
                tmp = new LinkedHashSet<String>(cp.getWrites());
                tmp.addAll(tp.getWrites());
                cp.setWrites(new ArrayList<String>(tmp));
            }
        });
        commonSlots.putAll(packagerSlots);
        packager.setSlots(new ArrayList<Snap.Slot>(commonSlots.values()));
    }
}

