/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Flatpak;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Github;
import org.jreleaser.model.Icon;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Screenshot;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class FlatpakPackagerProcessor
extends AbstractRepositoryPackagerProcessor<Flatpak> {
    public FlatpakPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        this.setupPrepare(distribution, props);
        super.doPrepareDistribution(distribution, props);
    }

    private void setupPrepare(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Artifact artifact = (Artifact)props.get("distributionArtifact");
        Path artifactPath = artifact.getResolvedPath(this.context, distribution);
        String artifactFileName = StringUtils.getFilename((String)artifactPath.getFileName().toString(), (Collection)((Flatpak)this.packager).getSupportedExtensions(distribution));
        try {
            List entries = org.jreleaser.util.FileUtils.inspectArchive((Path)artifactPath);
            LinkedHashSet directories = new LinkedHashSet();
            ArrayList binaries = new ArrayList();
            ArrayList files = new ArrayList();
            entries.stream().filter(e -> !e.endsWith(distribution.getExecutable().resolveWindowsExtension())).filter(e -> !e.endsWith("/")).map(e -> e.substring(artifactFileName.length() + 1)).filter(e -> e.startsWith("bin/")).sorted().forEach(entry -> {
                String[] parts = entry.split("/");
                binaries.add(parts[1]);
            });
            entries.stream().filter(e -> !e.endsWith(distribution.getExecutable().resolveWindowsExtension())).filter(e -> !e.endsWith("/")).map(e -> e.substring(artifactFileName.length() + 1)).filter(e -> !e.startsWith("bin/")).sorted().forEach(entry -> {
                String[] parts = entry.split("/");
                if (parts.length > 1) {
                    directories.add(parts[0]);
                }
                files.add(entry);
            });
            props.put("flatpakDirectories", directories);
            props.put("flatpakBinaries", binaries);
            props.put("flatpakFiles", files);
        }
        catch (IOException e2) {
            throw new PackagerProcessingException("ERROR", (Throwable)e2);
        }
        GitService gitService = this.context.getModel().getRelease().getGitService();
        try {
            props.put("flatpakReleases", Releasers.releaserFor((JReleaserContext)this.context).listReleases(gitService.getOwner(), gitService.getName()).stream().map(r -> Release.of(r.getUrl(), r.getVersion().toString(), r.getPublishedAt())).collect(Collectors.toList()));
        }
        catch (IOException e3) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e3);
        }
        props.put("flatpakScreenshots", ((Flatpak)this.packager).getScreenshots().stream().map(Screenshot::asScreenshotTemplate).collect(Collectors.toList()));
        this.context.getLogger().debug(RB.$((String)"packager.fetch.icons", (Object[])new Object[0]));
        props.put("flatpakIcons", ((Flatpak)this.packager).getIcons());
        for (Icon icon : ((Flatpak)this.packager).getIcons()) {
            String iconUrl = Templates.resolveTemplate((String)icon.getUrl(), props);
            String iconExt = StringUtils.getFilenameExtension((String)iconUrl);
            Path iconPath = Paths.get(((Flatpak)this.packager).getTemplateDirectory(), "icons", icon.getWidth() + "x" + icon.getHeight(), distribution.getExecutable().getName() + "." + iconExt);
            iconPath = this.context.getBasedir().resolve(iconPath);
            if (Files.exists(iconPath, new LinkOption[0])) continue;
            this.context.getLogger().debug("{} -> {}", new Object[]{iconUrl, this.context.relativizeToBasedir(iconPath)});
            try {
                FileUtils.copyURLToFile((URL)new URL(iconUrl), (File)iconPath.toFile(), (int)20000, (int)60000);
            }
            catch (IOException e4) {
                throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{iconUrl}), (Throwable)e4);
            }
        }
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        props.put("projectAuthors", this.context.getModel().getProject().getAuthors());
        props.put("flatpakUrls", this.context.getModel().getProject().getLinks().asLinkTemplates());
        props.put("flatpakComponentId", ((Flatpak)this.getPackager()).getComponentId());
        props.put("flatpakCategories", ((Flatpak)this.getPackager()).getCategories());
        props.put("flatpakCategoriesByComma", String.join((CharSequence)",", ((Flatpak)this.getPackager()).getCategories()));
        props.put("flatpakCategoriesBySemicolon", String.join((CharSequence)";", ((Flatpak)this.getPackager()).getCategories()) + (((Flatpak)this.getPackager()).getCategories().size() > 1 ? ";" : ""));
        props.put("flatpakDeveloperName", ((Flatpak)this.getPackager()).getDeveloperName());
        props.put("flatpakRepoOwner", ((Flatpak)this.packager).getRepository().getOwner());
        props.put("flatpakRepoName", ((Flatpak)this.packager).getRepository().getName());
        props.put("flatpakHasSdkExtensions", !((Flatpak)this.packager).getSdkExtensions().isEmpty());
        props.put("flatpakSdkExtensions", ((Flatpak)this.packager).getSdkExtensions());
        props.put("flatpakHasFinishArgs", !((Flatpak)this.packager).getFinishArgs().isEmpty());
        props.put("flatpakFinishArgs", ((Flatpak)this.packager).getFinishArgs().stream().map(MustacheUtils::passThrough).collect(Collectors.toList()));
        props.put("flatpakRuntime", ((Flatpak)this.packager).getRuntime().runtime());
        props.put("flatpakRuntimeVersion", ((Flatpak)this.packager).getRuntimeVersion());
        props.put("flatpakSdk", ((Flatpak)this.packager).getRuntime().sdk());
        props.put("flatpakIncludeOpendJdk", StringUtils.isFalse(((Flatpak)this.packager).getExtraProperties().get("skipOpenjdk")));
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Optional<Stereotype> stereotype;
        GitService gitService = this.context.getModel().getRelease().getGitService();
        if (fileName.contains("github") && !(gitService instanceof Github)) {
            return;
        }
        if (fileName.contains("-github")) {
            fileName = org.apache.commons.lang3.StringUtils.remove((String)fileName, (String)"-github");
        }
        if ((stereotype = this.resolveStereotype(fileName = TemplateUtils.trimTplExtension((String)fileName))).isPresent()) {
            if (distribution.getStereotype() == stereotype.get()) {
                fileName = fileName.substring(distribution.getStereotype().toString().length() + 1);
            } else {
                return;
            }
        }
        Path outputFile = outputDirectory.resolve(fileName);
        switch (fileName) {
            case "app.yml": {
                outputFile = outputDirectory.resolve(((Flatpak)this.getPackager()).getComponentId() + ".yml");
                break;
            }
            case "app.desktop": {
                outputFile = outputDirectory.resolve(((Flatpak)this.getPackager()).getComponentId() + ".desktop");
                break;
            }
            case "metainfo.xml": {
                outputFile = outputDirectory.resolve(((Flatpak)this.getPackager()).getComponentId() + ".metainfo.xml");
            }
        }
        this.writeFile(content, outputFile);
    }

    private Optional<Stereotype> resolveStereotype(String fileName) {
        for (Stereotype stereotype : ((Flatpak)this.packager).getSupportedStereotypes()) {
            if (!fileName.startsWith(stereotype.toString() + "-")) continue;
            return Optional.of(stereotype);
        }
        return Optional.empty();
    }

    public static class Release {
        private final String url;
        private final String version;
        private final String date;

        private Release(String url, String version, String date) {
            this.url = url;
            this.version = version;
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDate() {
            return this.date;
        }

        public static Release of(String url, String version, Date date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return new Release(url, version, format.format(date));
        }
    }
}

