/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.slack;

import java.util.ArrayList;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.slack.SlackException;
import org.jreleaser.sdk.slack.SlackSdk;
import org.jreleaser.sdk.slack.api.Message;
import org.jreleaser.util.StringUtils;

public class SlackAnnouncer
implements Announcer<org.jreleaser.model.api.announce.SlackAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.SlackAnnouncer slack;

    public SlackAnnouncer(JReleaserContext context) {
        this.context = context;
        this.slack = context.getModel().getAnnounce().getSlack();
    }

    public org.jreleaser.model.api.announce.SlackAnnouncer getAnnouncer() {
        return this.slack.asImmutable();
    }

    public String getName() {
        return "slack";
    }

    public boolean isEnabled() {
        return this.slack.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.slack.getMessage())) {
            message = this.slack.getResolvedMessage(this.context);
        } else {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.slack.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().debug("message: {}", new Object[]{message});
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.slack.getToken())) {
            this.context.getLogger().info("channel: {}", new Object[]{this.slack.getChannel()});
            try {
                SlackSdk sdk = SlackSdk.builder(this.context.asImmutable()).connectTimeout(this.slack.getConnectTimeout()).readTimeout(this.slack.getReadTimeout()).token(this.context.isDryrun() ? "**UNDEFINED**" : this.slack.getToken()).dryrun(this.context.isDryrun()).build();
                for (String channel : this.slack.getChannels()) {
                    sdk.message(channel, message);
                }
            }
            catch (SlackException e) {
                this.context.getLogger().trace((Throwable)e);
                errors.add(e.toString());
            }
        }
        if (StringUtils.isNotBlank((String)this.slack.getWebhook()) && !this.context.isDryrun()) {
            try {
                ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)this.slack.getWebhook(), (int)this.slack.getConnectTimeout(), (int)this.slack.getReadTimeout(), (Object)Message.of(message));
            }
            catch (AnnounceException e) {
                this.context.getLogger().trace((Throwable)e);
                errors.add(e.toString());
            }
        }
        if (!errors.isEmpty()) {
            throw new AnnounceException(String.join((CharSequence)System.lineSeparator(), errors));
        }
    }
}

