/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.FtpUploader;
import org.jreleaser.model.internal.validation.common.FtpValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class FtpUploaderValidator {
    private FtpUploaderValidator() {
    }

    public static void validateFtpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, FtpUploader> ftp = context.getModel().getUpload().getFtp();
        if (!ftp.isEmpty()) {
            context.getLogger().debug("upload.ftp");
        }
        for (Map.Entry<String, FtpUploader> e : ftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            Errors incoming = new Errors();
            FtpUploaderValidator.validateFtp(context, e.getValue(), incoming);
            Validator.mergeErrors(context, errors, incoming, e.getValue());
        }
    }

    private static void validateFtp(JReleaserContext context, FtpUploader uploader, Errors errors) {
        context.getLogger().debug("upload.ftp.{}", new Object[]{uploader.getName()});
        Validator.resolveActivatable(context, (Activatable)uploader, CollectionUtils.listOf((Object[])new String[]{"upload.ftp." + uploader.getName(), "upload.ftp"}), "NEVER");
        if (!uploader.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(uploader.isArtifacts() || uploader.isFiles() || uploader.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{uploader.getType(), uploader.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            uploader.disable();
            return;
        }
        FtpValidator.validateFtp(context, uploader, "upload", uploader.getName(), errors, context.isDryrun());
        if (StringUtils.isBlank((String)uploader.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"upload.ftp." + uploader.getName() + ".path"}));
        }
        Validator.validateTimeout(uploader);
    }
}

