/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractModelCommand;
import org.jreleaser.cli.IO;
import org.jreleaser.util.PlatformUtils;
import picocli.CommandLine;

@CommandLine.Command
public abstract class AbstractPlatformAwareModelCommand<C extends IO>
extends AbstractModelCommand<C> {
    @CommandLine.Option(names={"-scp", "--select-current-platform"})
    Boolean selectCurrentPlatform;
    @CommandLine.Option(names={"-sp", "--select-platform"}, paramLabel="<platform>")
    String[] selectPlatforms;
    @CommandLine.Option(names={"-rp", "--reject-platform"}, paramLabel="<platform>")
    String[] rejectedPlatforms;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-scp", "--select-current-platform", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-sp", "--select-platform", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-rp", "--reject-platform", "1.5.0"));
    }

    @Override
    protected List<String> collectSelectedPlatforms() {
        boolean resolvedSelectCurrentPlatform = this.resolveBoolean("SELECT_CURRENT_PLATFORM", this.selectCurrentPlatform);
        if (resolvedSelectCurrentPlatform) {
            return Collections.singletonList(PlatformUtils.getCurrentFull());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.selectPlatforms && this.selectPlatforms.length > 0) {
            Collections.addAll(list, this.selectPlatforms);
        }
        return this.resolveCollection("SELECT_PLATFORMS", list);
    }

    @Override
    protected List<String> collectRejectedPlatforms() {
        ArrayList<String> list = new ArrayList<String>();
        if (null != this.rejectedPlatforms && this.rejectedPlatforms.length > 0) {
            Collections.addAll(list, this.rejectedPlatforms);
        }
        return this.resolveCollection("REJECT_PLATFORMS", list);
    }
}

