/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.LintScanner;
import com.github.sbaudoin.yamllint.LintStreamReader;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.scanner.ScannerException;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

public class QuotedStrings
extends TokenRule {
    private static final String MSG_NOT_QUOTED = "string value is not quoted";
    private static final String MSG_NOT_QUOTED_WITH_QUOTES = "string value is not quoted with %s quotes";
    private static final List<String> FLOW_TOKENS = Arrays.asList(",", "[", "]", "{", "}");
    private static final String FLOW_NEST_COUNT_KEY = "flow_nest_count";
    private static final String OCTAL_INT_RE = "^([-+]?0b[0-1_]+|[-+]?0o?[0-7_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*(?::[0-5]?\\d)+)$";
    public static final String OPTION_QUOTE_TYPE = "quote-type";
    public static final String OPTION_REQUIRED = "required";
    public static final String OPTION_EXTRA_REQUIRED = "extra-required";
    public static final String OPTION_EXTRA_ALLOWED = "extra-allowed";
    public static final String OPTION_ALLOW_QUOTED_QUOTES = "allow-quoted-quotes";
    public static final String QUOTE_STYLE_SINGLE = "single";
    public static final String QUOTE_STYLE_DOUBLE = "double";
    public static final String QUOTE_STYLE_ANY = "any";
    public static final String ONLY_WHEN_NEEDED = "only-when-needed";

    public QuotedStrings() {
        this.registerOption(OPTION_QUOTE_TYPE, Arrays.asList(QUOTE_STYLE_ANY, QUOTE_STYLE_SINGLE, QUOTE_STYLE_DOUBLE));
        this.registerOption(OPTION_REQUIRED, Arrays.asList(Boolean.class, String.class, ONLY_WHEN_NEEDED), true);
        this.registerListOption(OPTION_EXTRA_REQUIRED, Collections.emptyList());
        this.registerListOption(OPTION_EXTRA_ALLOWED, Collections.emptyList());
        this.registerOption(OPTION_ALLOW_QUOTED_QUOTES, false);
    }

    @Override
    public String validate(Map<String, Object> conf) {
        if (conf.get(OPTION_REQUIRED) instanceof Boolean) {
            boolean req = (Boolean)conf.get(OPTION_REQUIRED);
            if (req && !((List)conf.get(OPTION_EXTRA_ALLOWED)).isEmpty()) {
                return "cannot use both \"required: true\" and \"extra-allowed\"";
            }
            if (req && !((List)conf.get(OPTION_EXTRA_REQUIRED)).isEmpty()) {
                return "cannot use both \"required: true\" and \"extra-required\"";
            }
            if (!req && !((List)conf.get(OPTION_EXTRA_ALLOWED)).isEmpty()) {
                return "cannot use both \"required: false\" and \"extra-allowed\"";
            }
        }
        return null;
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (!context.containsKey(FLOW_NEST_COUNT_KEY)) {
            context.put(FLOW_NEST_COUNT_KEY, 0);
        }
        if (token instanceof FlowMappingStartToken || token instanceof FlowSequenceStartToken) {
            context.put(FLOW_NEST_COUNT_KEY, (Integer)context.get(FLOW_NEST_COUNT_KEY) + 1);
        } else if (token instanceof FlowMappingEndToken || token instanceof FlowSequenceEndToken) {
            context.put(FLOW_NEST_COUNT_KEY, (Integer)context.get(FLOW_NEST_COUNT_KEY) - 1);
        }
        if (!(token instanceof ScalarToken && (prev instanceof BlockEntryToken || prev instanceof FlowEntryToken || prev instanceof FlowSequenceStartToken || prev instanceof TagToken || prev instanceof ValueToken))) {
            return problems;
        }
        if (prev instanceof TagToken && "!!".equals(((TagToken)prev).getValue().getHandle())) {
            return problems;
        }
        Resolver resolver = new Resolver();
        resolver.addImplicitResolver(Tag.INT, Pattern.compile(OCTAL_INT_RE), "-+0123456789");
        Tag tag = resolver.resolve(NodeId.scalar, ((ScalarToken)token).getValue(), true);
        if (((ScalarToken)token).getPlain() && tag != Tag.STR) {
            return problems;
        }
        if (!(((ScalarToken)token).getPlain() || ((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.LITERAL && ((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.FOLDED)) {
            return problems;
        }
        String quoteType = (String)conf.get(OPTION_QUOTE_TYPE);
        String msg = null;
        if (conf.get(OPTION_REQUIRED) instanceof Boolean && Boolean.TRUE.equals(conf.get(OPTION_REQUIRED))) {
            if (!(((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.PLAIN && (this.quoteMatch(quoteType, ((ScalarToken)token).getStyle()) || ((Boolean)conf.get(OPTION_ALLOW_QUOTED_QUOTES)).booleanValue() && this.hasQuotedQuotes(token)))) {
                msg = String.format(MSG_NOT_QUOTED_WITH_QUOTES, quoteType);
            }
        } else if (conf.get(OPTION_REQUIRED) instanceof Boolean && Boolean.FALSE.equals(conf.get(OPTION_REQUIRED))) {
            boolean isExtraRequired;
            if (!(((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.PLAIN || this.quoteMatch(quoteType, ((ScalarToken)token).getStyle()) || ((Boolean)conf.get(OPTION_ALLOW_QUOTED_QUOTES)).booleanValue() && this.hasQuotedQuotes(token))) {
                msg = String.format(MSG_NOT_QUOTED_WITH_QUOTES, quoteType);
            } else if (((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.PLAIN && (isExtraRequired = ((List)conf.get(OPTION_EXTRA_REQUIRED)).stream().anyMatch(r -> Pattern.compile(r).matcher(((ScalarToken)token).getValue()).find()))) {
                msg = MSG_NOT_QUOTED;
            }
        } else if (ONLY_WHEN_NEEDED.equals(conf.get(OPTION_REQUIRED))) {
            if (((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.PLAIN && tag == Tag.STR && ((ScalarToken)token).getValue() != null && !this.quotesAreNeeded(((ScalarToken)token).getValue(), (Integer)context.get(FLOW_NEST_COUNT_KEY) > 0)) {
                boolean isExtraRequired = ((List)conf.get(OPTION_EXTRA_REQUIRED)).stream().anyMatch(r -> Pattern.compile(r).matcher(((ScalarToken)token).getValue()).find());
                boolean isExtraAllowed = ((List)conf.get(OPTION_EXTRA_ALLOWED)).stream().anyMatch(r -> Pattern.compile(r).matcher(((ScalarToken)token).getValue()).find());
                if (!isExtraRequired && !isExtraAllowed) {
                    msg = String.format("string value is redundantly quoted with %s quotes", quoteType);
                }
            } else if (!(((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.PLAIN || this.quoteMatch(quoteType, ((ScalarToken)token).getStyle()) || ((Boolean)conf.get(OPTION_ALLOW_QUOTED_QUOTES)).booleanValue() && this.hasQuotedQuotes(token))) {
                msg = String.format(MSG_NOT_QUOTED_WITH_QUOTES, quoteType);
            } else if (((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.PLAIN) {
                boolean isExtraRequired;
                boolean bl = isExtraRequired = !((List)conf.get(OPTION_EXTRA_REQUIRED)).isEmpty() && ((List)conf.get(OPTION_EXTRA_REQUIRED)).stream().anyMatch(r -> Pattern.compile(r).matcher(((ScalarToken)token).getValue()).find());
                if (isExtraRequired) {
                    msg = MSG_NOT_QUOTED;
                }
            }
        }
        if (msg != null) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, msg));
        }
        return problems;
    }

    private boolean quoteMatch(String quoteType, DumperOptions.ScalarStyle tokenStyle) {
        return QUOTE_STYLE_ANY.equals(quoteType) || QUOTE_STYLE_SINGLE.equals(quoteType) && tokenStyle == DumperOptions.ScalarStyle.SINGLE_QUOTED || QUOTE_STYLE_DOUBLE.equals(quoteType) && tokenStyle == DumperOptions.ScalarStyle.DOUBLE_QUOTED;
    }

    private boolean quotesAreNeeded(String string, boolean isInsideAFlow) {
        if (isInsideAFlow) {
            if (FLOW_TOKENS.stream().anyMatch(string::contains)) {
                return true;
            }
        }
        LintScanner loader = new LintScanner(new LintStreamReader("key: " + string));
        for (int i = 0; i < 5; ++i) {
            loader.getToken();
        }
        try {
            Token a = loader.getToken();
            Token b = loader.getToken();
            return !(a instanceof ScalarToken) || ((ScalarToken)a).getStyle() != DumperOptions.ScalarStyle.PLAIN || !(b instanceof BlockEndToken) || !string.equals(((ScalarToken)a).getValue());
        }
        catch (ScannerException e) {
            return true;
        }
    }

    private boolean hasQuotedQuotes(Token token) {
        return token instanceof ScalarToken && (((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.SINGLE_QUOTED && ((ScalarToken)token).getValue().contains("\"") || ((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.DOUBLE_QUOTED && ((ScalarToken)token).getValue().contains("'"));
    }
}

