/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jreleaser.assemblers.AbstractJavaAssemblerProcessor;
import org.jreleaser.assemblers.AssemblerUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class JlinkAssemblerProcessor
extends AbstractJavaAssemblerProcessor<org.jreleaser.model.api.assemble.JlinkAssembler, JlinkAssembler> {
    public JlinkAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path jdkPath = ((JlinkAssembler)this.assembler).getJdk().getEffectivePath(this.context, this.assembler);
        SemanticVersion jdkVersion = SemanticVersion.of((String)AssemblerUtils.readJavaVersion(jdkPath));
        this.context.getLogger().debug(RB.$((String)"assembler.jlink.jdk", (Object[])new Object[0]), new Object[]{jdkVersion, jdkPath.toAbsolutePath().toString()});
        for (Artifact targetJdk : ((JlinkAssembler)this.assembler).getTargetJdks()) {
            if (!this.context.isPlatformSelected(targetJdk)) continue;
            Path targetJdkPath = targetJdk.getEffectivePath(this.context, this.assembler);
            SemanticVersion targetJdkVersion = SemanticVersion.of((String)AssemblerUtils.readJavaVersion(targetJdkPath));
            this.context.getLogger().debug(RB.$((String)"assembler.jlink.target", (Object[])new Object[0]), new Object[]{jdkVersion, targetJdkPath.toAbsolutePath().toString()});
            if (jdkVersion.getMajor() == targetJdkVersion.getMajor()) continue;
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jlink_target_not_compatible", (Object[])new Object[]{targetJdkVersion, jdkVersion}));
        }
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        String imageName = ((JlinkAssembler)this.assembler).getResolvedImageName(this.context);
        if (StringUtils.isNotBlank((String)((JlinkAssembler)this.assembler).getImageNameTransform())) {
            imageName = ((JlinkAssembler)this.assembler).getResolvedImageNameTransform(this.context);
        }
        for (Artifact targetJdk : ((JlinkAssembler)this.assembler).getTargetJdks()) {
            if (!this.context.isPlatformSelected(targetJdk)) continue;
            String platform = targetJdk.getPlatform();
            Path jarsDirectory = inputsDirectory.resolve("jars");
            Path universalJarsDirectory = jarsDirectory.resolve("universal");
            this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(universalJarsDirectory)});
            Set<Path> jars = AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, universalJarsDirectory, "");
            Path platformJarsDirectory = jarsDirectory.resolve(platform);
            this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(platformJarsDirectory)});
            jars.addAll(AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, platformJarsDirectory, platform));
            TreeSet<String> moduleNames = new TreeSet<String>(this.resolveModuleNames(this.context, jdkPath, jarsDirectory, platform, props));
            this.context.getLogger().debug(RB.$((String)"assembler.resolved.module.names", (Object[])new Object[0]), new Object[]{moduleNames});
            if (moduleNames.isEmpty()) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_no_module_names", (Object[])new Object[0]));
            }
            moduleNames.addAll(((JlinkAssembler)this.assembler).getAdditionalModuleNames());
            if (StringUtils.isNotBlank((String)((JlinkAssembler)this.assembler).getJava().getMainModule())) {
                moduleNames.add(((JlinkAssembler)this.assembler).getJava().getMainModule());
            }
            this.context.getLogger().debug(RB.$((String)"assembler.module.names", (Object[])new Object[0]), new Object[]{moduleNames});
            String str = targetJdk.getExtraProperties().getOrDefault("archiveFormat", "ZIP").toString();
            Archive.Format archiveFormat = Archive.Format.of((String)str);
            this.jlink(assembleDirectory, jdkPath, targetJdk, moduleNames, imageName, archiveFormat);
        }
    }

    private Artifact jlink(Path assembleDirectory, Path jdkPath, Artifact targetJdk, Set<String> moduleNames, String imageName, Archive.Format archiveFormat) throws AssemblerProcessingException {
        String platform = targetJdk.getPlatform();
        String platformReplaced = ((JlinkAssembler)this.assembler).getPlatform().applyReplacements(platform);
        String finalImageName = imageName + "-" + platformReplaced;
        this.context.getLogger().info("- {}", new Object[]{finalImageName});
        Path inputsDirectory = assembleDirectory.resolve("inputs");
        Path jarsDirectory = inputsDirectory.resolve("jars");
        Path workDirectory = assembleDirectory.resolve("work-" + platform);
        Path imageDirectory = workDirectory.resolve(finalImageName).toAbsolutePath();
        try {
            FileUtils.deleteFiles((Path)imageDirectory);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_image", (Object[])new Object[]{finalImageName}), (Throwable)e);
        }
        String moduleName = ((JlinkAssembler)this.assembler).getJava().getMainModule();
        String modulePath = this.maybeQuote(targetJdk.getEffectivePath(this.context, this.assembler).resolve("jmods").toAbsolutePath().toString());
        if (StringUtils.isNotBlank((String)moduleName) || ((JlinkAssembler)this.assembler).isCopyJars()) {
            modulePath = modulePath + File.pathSeparator + this.maybeQuote(jarsDirectory.resolve("universal").toAbsolutePath().toString());
            try {
                Path platformJarsDirectory = jarsDirectory.resolve(platform).toAbsolutePath();
                if ((Long)FileUtils.listFilesAndProcess((Path)platformJarsDirectory, Stream::count) > 1L) {
                    modulePath = modulePath + File.pathSeparator + this.maybeQuote(platformJarsDirectory.toString());
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[]{e}));
            }
        }
        Path jlinkExecutable = jdkPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "jlink.exe" : "jlink").toAbsolutePath();
        Command cmd = new Command(jlinkExecutable.toString(), true).args((Collection)((JlinkAssembler)this.assembler).getArgs()).arg("--module-path").arg(modulePath).arg("--add-modules").arg(String.join((CharSequence)",", moduleNames));
        if (StringUtils.isNotBlank((String)moduleName)) {
            cmd.arg("--launcher").arg(((JlinkAssembler)this.assembler).getExecutable() + "=" + moduleName + "/" + ((JlinkAssembler)this.assembler).getJava().getMainClass());
        }
        cmd.arg("--output").arg(this.maybeQuote(imageDirectory.toString()));
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.executeCommandCapturing(cmd, out);
        if (StringUtils.isBlank((String)moduleName)) {
            if (((JlinkAssembler)this.assembler).isCopyJars()) {
                Path outputJarsDirectory = imageDirectory.resolve("jars");
                try {
                    Files.createDirectory(outputJarsDirectory, new FileAttribute[0]);
                    FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)jarsDirectory.resolve("universal"), (Path)outputJarsDirectory);
                    FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)jarsDirectory.resolve(platform), (Path)outputJarsDirectory);
                }
                catch (IOException e) {
                    throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copy_jars", (Object[])new Object[]{this.context.relativizeToBasedir(outputJarsDirectory)}), (Throwable)e);
                }
            }
            try {
                if (PlatformUtils.isWindows((String)platform)) {
                    Files.copy(inputsDirectory.resolve(((JlinkAssembler)this.assembler).getExecutable().concat(".bat")), imageDirectory.resolve("bin").resolve(((JlinkAssembler)this.assembler).getExecutable().concat(".bat")), new CopyOption[0]);
                } else {
                    Path launcher = imageDirectory.resolve("bin").resolve(((JlinkAssembler)this.assembler).getExecutable());
                    Files.copy(inputsDirectory.resolve(((JlinkAssembler)this.assembler).getExecutable()), launcher, new CopyOption[0]);
                    FileUtils.grantExecutableAccess((Path)launcher);
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copy_launcher", (Object[])new Object[]{this.context.relativizeToBasedir(imageDirectory.resolve("bin"))}), (Throwable)e);
            }
        }
        try {
            Path imageArchive = assembleDirectory.resolve(finalImageName + "." + archiveFormat.extension());
            FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)this.context.getBasedir(), (Path)imageDirectory, path -> path.getFileName().startsWith("LICENSE"));
            this.copyFiles(this.context, imageDirectory);
            this.copyFileSets(this.context, imageDirectory);
            switch (archiveFormat) {
                case ZIP: {
                    FileUtils.zip((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TAR: {
                    FileUtils.tar((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TGZ: 
                case TAR_GZ: {
                    FileUtils.tgz((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TXZ: 
                case TAR_XZ: {
                    FileUtils.xz((Path)workDirectory, (Path)imageArchive);
                    break;
                }
                case TBZ2: 
                case TAR_BZ2: {
                    FileUtils.bz2((Path)workDirectory, (Path)imageArchive);
                }
            }
            this.context.getLogger().debug("- {}", new Object[]{imageArchive.getFileName()});
            return Artifact.of((Path)imageArchive, (String)platform);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private Set<String> resolveModuleNames(JReleaserContext context, Path jdkPath, Path jarsDirectory, String platform, Map<String, Object> props) throws AssemblerProcessingException {
        if (!((JlinkAssembler)this.assembler).getModuleNames().isEmpty()) {
            return ((JlinkAssembler)this.assembler).getModuleNames();
        }
        Path jdepsExecutable = jdkPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "jdeps.exe" : "jdeps").toAbsolutePath();
        Command cmd = new Command(jdepsExecutable.toAbsolutePath().toString());
        String multiRelease = ((JlinkAssembler)this.assembler).getJdeps().getMultiRelease();
        if (StringUtils.isNotBlank((String)multiRelease)) {
            cmd.arg("--multi-release").arg(multiRelease);
        }
        if (((JlinkAssembler)this.assembler).getJdeps().isIgnoreMissingDeps()) {
            cmd.arg("--ignore-missing-deps");
        }
        cmd.arg("--print-module-deps");
        String moduleName = ((JlinkAssembler)this.assembler).getJava().getMainModule();
        if (StringUtils.isNotBlank((String)moduleName)) {
            cmd.arg("--module").arg(moduleName).arg("--module-path");
            this.calculateJarPath(jarsDirectory, platform, cmd, true);
        } else if (!((JlinkAssembler)this.assembler).getJdeps().getTargets().isEmpty()) {
            cmd.arg("--class-path");
            if (((JlinkAssembler)this.assembler).getJdeps().isUseWildcardInPath()) {
                cmd.arg("universal" + File.separator + "*" + File.pathSeparator + platform + File.separator + "*");
            } else {
                this.calculateJarPath(jarsDirectory, platform, cmd, true);
            }
            ((JlinkAssembler)this.assembler).getJdeps().getTargets().stream().map(target -> Templates.resolveTemplate((String)target, (Map)props)).filter(StringUtils::isNotBlank).map(AssemblerUtils::maybeAdjust).forEach(arg_0 -> ((Command)cmd).arg(arg_0));
        } else {
            this.calculateJarPath(jarsDirectory, platform, cmd, false);
        }
        context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.executeCommandCapturing(jarsDirectory, cmd, out);
        String output = out.toString().trim();
        long lineCount = Arrays.stream(output.split(System.lineSeparator())).map(String::trim).count();
        if (lineCount == 1L && StringUtils.isNotBlank((String)output)) {
            return Arrays.stream(output.split(",")).collect(Collectors.toSet());
        }
        throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_jdeps_error", (Object[])new Object[]{output}));
    }

    private void calculateJarPath(Path jarsDirectory, String platform, Command cmd, boolean join) throws AssemblerProcessingException {
        try {
            if (join) {
                StringBuilder pathBuilder = new StringBuilder();
                String s = (String)FileUtils.listFilesAndProcess((Path)jarsDirectory.resolve("universal"), files -> files.map(jarsDirectory::relativize).map(Object::toString).collect(Collectors.joining(File.pathSeparator)));
                pathBuilder.append(s);
                String platformSpecific = (String)FileUtils.listFilesAndProcess((Path)jarsDirectory.resolve(platform), files -> files.map(jarsDirectory::relativize).map(Object::toString).collect(Collectors.joining(File.pathSeparator)));
                if (StringUtils.isNotBlank((String)platformSpecific)) {
                    pathBuilder.append(File.pathSeparator).append(platformSpecific);
                }
                cmd.arg(pathBuilder.toString());
            } else {
                FileUtils.listFilesAndConsume((Path)jarsDirectory.resolve("universal"), files -> files.map(jarsDirectory::relativize).map(Object::toString).forEach(arg_0 -> ((Command)cmd).arg(arg_0)));
                FileUtils.listFilesAndConsume((Path)jarsDirectory.resolve(platform), files -> files.map(jarsDirectory::relativize).map(Object::toString).forEach(arg_0 -> ((Command)cmd).arg(arg_0)));
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_jdeps_error", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Override
    protected void writeFile(Project project, String content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputDirectory = (Path)props.get("distributionAssembleDirectory");
        Path inputsDirectory = outputDirectory.resolve("inputs");
        try {
            Files.createDirectories(inputsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_create_directories", (Object[])new Object[0]), (Throwable)e);
        }
        Path outputFile = "launcher.bat".equals(fileName) ? inputsDirectory.resolve(((JlinkAssembler)this.assembler).getExecutable().concat(".bat")) : ("launcher".equals(fileName) ? inputsDirectory.resolve(((JlinkAssembler)this.assembler).getExecutable()) : inputsDirectory.resolve(fileName));
        this.writeFile(content, outputFile);
    }
}

