/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.download;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.model.api.download.Downloader;
import org.jreleaser.model.internal.download.AbstractDownloader;
import org.jreleaser.model.internal.download.SshDownloader;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public abstract class AbstractSshDownloader<A extends Downloader, S extends AbstractSshDownloader<A, S>>
extends AbstractDownloader<A, S>
implements SshDownloader<A> {
    protected String username;
    protected String password;
    protected String host;
    protected Integer port;
    protected String knownHostsFile;
    protected String publicKey;
    protected String privateKey;
    protected String passphrase;
    protected String fingerprint;

    public AbstractSshDownloader(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.username = this.merge(this.username, ((AbstractSshDownloader)source).username);
        this.password = this.merge(this.password, ((AbstractSshDownloader)source).password);
        this.host = this.merge(this.host, ((AbstractSshDownloader)source).host);
        this.port = this.merge(this.port, ((AbstractSshDownloader)source).port);
        this.knownHostsFile = this.merge(this.knownHostsFile, ((AbstractSshDownloader)source).knownHostsFile);
        this.publicKey = this.merge(this.publicKey, ((AbstractSshDownloader)source).publicKey);
        this.privateKey = this.merge(this.privateKey, ((AbstractSshDownloader)source).privateKey);
        this.passphrase = this.merge(this.passphrase, ((AbstractSshDownloader)source).passphrase);
        this.fingerprint = this.merge(this.fingerprint, ((AbstractSshDownloader)source).fingerprint);
    }

    protected abstract String getEnvPrefix();

    @Override
    public String getResolvedUsername() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_USERNAME", "SSH_" + Env.toVar((String)this.name) + "_USERNAME", this.getEnvPrefix() + "_USERNAME", "SSH_USERNAME"}), (String)this.username);
    }

    @Override
    public String getResolvedPassword() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PASSWORD", "SSH_" + Env.toVar((String)this.name) + "_PASSWORD", this.getEnvPrefix() + "_PASSWORD", "SSH_PASSWORD"}), (String)this.password);
    }

    @Override
    public String getResolvedHost() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_HOST", "SSH_" + Env.toVar((String)this.name) + "_HOST", this.getEnvPrefix() + "_HOST", "SSH_HOST"}), (String)this.host);
    }

    @Override
    public Integer getResolvedPort() {
        String value = Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PORT", "SSH_" + Env.toVar((String)this.name) + "_PORT", this.getEnvPrefix() + "_PORT", "SSH_PORT"}), (String)(null == this.port ? "" : String.valueOf(this.port)));
        return StringUtils.isBlank((String)value) ? 22 : Integer.parseInt(value);
    }

    @Override
    public String getResolvedPublicKey() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PUBLIC_KEY", "SSH_" + Env.toVar((String)this.name) + "_PUBLIC_KEY", this.getEnvPrefix() + "_PUBLIC_KEY", "SSH_PUBLIC_KEY"}), (String)this.publicKey);
    }

    @Override
    public String getResolvedPrivateKey() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PRIVATE_KEY", "SSH_" + Env.toVar((String)this.name) + "_PRIVATE_KEY", this.getEnvPrefix() + "_PRIVATE_KEY", "SSH_PRIVATE_KEY"}), (String)this.privateKey);
    }

    @Override
    public String getResolvedPassphrase() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PASSPHRASE", "SSH_" + Env.toVar((String)this.name) + "_PASSPHRASE", this.getEnvPrefix() + "_PASSPHRASE", "SSH_PASSPHRASE"}), (String)this.passphrase);
    }

    @Override
    public String getResolvedFingerprint() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_FINGERPRINT", "SSH_" + Env.toVar((String)this.name) + "_FINGERPRINT", this.getEnvPrefix() + "_FINGERPRINT", "SSH_FINGERPRINT"}), (String)this.fingerprint);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    @Override
    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String getPassphrase() {
        return this.passphrase;
    }

    @Override
    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", StringUtils.isNotBlank((String)this.getResolvedHost()) ? "************" : "**unset**");
        props.put("port", this.getResolvedPort());
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("knownHostsFile", this.knownHostsFile);
        props.put("publicKey", StringUtils.isNotBlank((String)this.getResolvedPublicKey()) ? "************" : "**unset**");
        props.put("privateKey", StringUtils.isNotBlank((String)this.getResolvedPrivateKey()) ? "************" : "**unset**");
        props.put("passphrase", StringUtils.isNotBlank((String)this.getResolvedPassphrase()) ? "************" : "**unset**");
        props.put("fingerprint", StringUtils.isNotBlank((String)this.getResolvedFingerprint()) ? "************" : "**unset**");
    }
}

