/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ArchiveAssemblerValidator
extends Validator {
    public static void validateArchive(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, ArchiveAssembler> archive = context.getModel().getAssemble().getArchive();
        if (!archive.isEmpty()) {
            context.getLogger().debug("assemble.archive");
        }
        for (Map.Entry<String, ArchiveAssembler> e : archive.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            ArchiveAssemblerValidator.validateArchive(context, mode, e.getValue(), errors);
        }
    }

    private static void validateArchive(JReleaserContext context, JReleaserContext.Mode mode, ArchiveAssembler archive, Errors errors) {
        context.getLogger().debug("assemble.archive.{}", new Object[]{archive.getName()});
        if (!archive.isActiveSet()) {
            archive.setActive(Active.NEVER);
        }
        if (!archive.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)archive.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"archive.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            archive.disable();
            return;
        }
        archive.setPlatform(archive.getPlatform().mergeValues(context.getModel().getPlatform()));
        if (null == archive.getDistributionType()) {
            archive.setDistributionType(Distribution.DistributionType.BINARY);
        }
        if (null == archive.getStereotype()) {
            archive.setStereotype(context.getModel().getProject().getStereotype());
        }
        if (StringUtils.isBlank((String)archive.getArchiveName())) {
            archive.setArchiveName("{{distributionName}}-{{projectVersion}}");
        }
        if (archive.getFormats().isEmpty()) {
            archive.addFormat(Archive.Format.ZIP);
        }
        if (archive.getFileSets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_archive_empty_fileset", (Object[])new Object[]{archive.getName()}));
        } else {
            int i = 0;
            for (FileSet fileSet : archive.getFileSets()) {
                ArchiveAssemblerValidator.validateFileSet(context, mode, archive, fileSet, i++, errors);
            }
        }
    }
}

