/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Map;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class Nexus2MavenDeployerValidator
extends Validator {
    public static void validateNexus2MavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, Nexus2MavenDeployer> artifactory = context.getModel().getDeploy().getMaven().getNexus2();
        if (!artifactory.isEmpty()) {
            context.getLogger().debug("deploy.maven.artifactory");
        }
        for (Map.Entry<String, Nexus2MavenDeployer> e : artifactory.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            Nexus2MavenDeployerValidator.validateNexus2MavenDeployer(context, mode, e.getValue(), errors);
        }
    }

    private static void validateNexus2MavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Nexus2MavenDeployer mavenDeployer, Errors errors) {
        if (StringUtils.isNotBlank((String)mavenDeployer.getUrl()) && mavenDeployer.getUrl().contains("oss.sonatype.org") && !mavenDeployer.isApplyMavenCentralRulesSet()) {
            mavenDeployer.setApplyMavenCentralRules(true);
        }
        MavenDeployersValidator.validateMavenDeployer(context, mode, mavenDeployer, errors);
    }
}

